/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.SystemProperties;
import com.helger.commons.ValueEnforcer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingBufferedWriter
extends Writer {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 16384;
    private Writer m_aWriter;
    private char[] m_aBuf;
    private final int m_nChars;
    private int m_nNextChar;
    private final String m_sLineSeparator;

    public NonBlockingBufferedWriter(@Nonnull Writer writer) {
        this(writer, 16384);
    }

    public NonBlockingBufferedWriter(@Nonnull Writer writer, @Nonnegative int n) {
        super((Object)writer);
        ValueEnforcer.isGT0(n, "BufSize");
        this.m_aWriter = writer;
        this.m_aBuf = new char[n];
        this.m_nChars = n;
        this.m_nNextChar = 0;
        this.m_sLineSeparator = SystemProperties.getLineSeparator();
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aWriter == null) {
            throw new IOException("Stream closed");
        }
    }

    void flushBuffer() throws IOException {
        this._ensureOpen();
        if (this.m_nNextChar != 0) {
            this.m_aWriter.write(this.m_aBuf, 0, this.m_nNextChar);
            this.m_nNextChar = 0;
        }
    }

    @Override
    public void write(int n) throws IOException {
        this._ensureOpen();
        if (this.m_nNextChar >= this.m_nChars) {
            this.flushBuffer();
        }
        this.m_aBuf[this.m_nNextChar++] = (char)n;
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public void write(char[] cArray, int n, int n2) throws IOException {
        this._ensureOpen();
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 == 0) {
            return;
        }
        if (n2 >= this.m_nChars) {
            this.flushBuffer();
            this.m_aWriter.write(cArray, n, n2);
        } else {
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = Math.min(this.m_nChars - this.m_nNextChar, n4 - n3);
                System.arraycopy(cArray, n3, this.m_aBuf, this.m_nNextChar, n5);
                n3 += n5;
                this.m_nNextChar += n5;
                if (this.m_nNextChar < this.m_nChars) continue;
                this.flushBuffer();
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public void write(String string, int n, int n2) throws IOException {
        this._ensureOpen();
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = Math.min(this.m_nChars - this.m_nNextChar, n4 - n3);
            string.getChars(n3, n3 + n5, this.m_aBuf, this.m_nNextChar);
            n3 += n5;
            this.m_nNextChar += n5;
            if (this.m_nNextChar < this.m_nChars) continue;
            this.flushBuffer();
        }
    }

    public void newLine() throws IOException {
        this.write(this.m_sLineSeparator);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.m_aWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.m_aWriter != null) {
            try {
                this.flushBuffer();
            }
            finally {
                this.m_aWriter.close();
                this.m_aWriter = null;
                this.m_aBuf = null;
            }
        }
    }
}

