/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.math.CombinationGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CombinationGeneratorFlexible<DATATYPE> {
    private final boolean m_bAllowEmpty;
    private final int m_nSlotCount;

    public CombinationGeneratorFlexible(@Nonnegative int n, boolean bl) {
        ValueEnforcer.isGE0(n, "SlotCount");
        this.m_nSlotCount = n;
        this.m_bAllowEmpty = bl;
    }

    public void iterateAllCombinations(@Nonnull List<DATATYPE> list, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> iNonThrowingRunnableWithParameter) {
        int n;
        ValueEnforcer.notNull(list, "Elements");
        ValueEnforcer.notNull(iNonThrowingRunnableWithParameter, "Callback");
        int n2 = n = this.m_bAllowEmpty ? 0 : 1;
        while (n <= this.m_nSlotCount) {
            if (list.isEmpty()) {
                iNonThrowingRunnableWithParameter.run(new ArrayList());
            } else {
                for (List<DATATYPE> list2 : new CombinationGenerator<DATATYPE>(list, n)) {
                    iNonThrowingRunnableWithParameter.run(list2);
                }
            }
            ++n;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> list) {
        ValueEnforcer.notNull(list, "Elements");
        final HashSet<List<DATATYPE>> hashSet = new HashSet<List<DATATYPE>>();
        this.iterateAllCombinations(list, new INonThrowingRunnableWithParameter<List<DATATYPE>>(){

            @Override
            public void run(List<DATATYPE> list) {
                hashSet.add(list);
            }
        });
        return hashSet;
    }

    public static <DATATYPE> void iterateAllCombinations(@Nonnull List<DATATYPE> list, boolean bl, @Nonnull INonThrowingRunnableWithParameter<List<DATATYPE>> iNonThrowingRunnableWithParameter) {
        new CombinationGeneratorFlexible<DATATYPE>(list.size(), bl).iterateAllCombinations(list, iNonThrowingRunnableWithParameter);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <DATATYPE> Set<List<DATATYPE>> getCombinations(@Nonnull List<DATATYPE> list, boolean bl) {
        return new CombinationGeneratorFlexible<DATATYPE>(list.size(), bl).getCombinations(list);
    }
}

