/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.parent.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.parent.IChildrenProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChildrenProviderSorting<CHILDTYPE>
implements IChildrenProvider<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final Comparator<? super CHILDTYPE> m_aComparator;

    public ChildrenProviderSorting(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull Comparator<? super CHILDTYPE> comparator) {
        this.m_aChildrenProvider = ValueEnforcer.notNull(iChildrenProvider, "ChildrenProvider");
        this.m_aComparator = ValueEnforcer.notNull(comparator, "Comparator");
    }

    @Nonnull
    public IChildrenProvider<CHILDTYPE> getChildrenProvider() {
        return this.m_aChildrenProvider;
    }

    @Nonnull
    public Comparator<? super CHILDTYPE> getComparator() {
        return this.m_aComparator;
    }

    @Override
    public final boolean hasChildren(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.hasChildren(CHILDTYPE);
    }

    @Override
    public final int getChildCount(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.getChildCount(CHILDTYPE);
    }

    @Override
    @Nullable
    public List<? extends CHILDTYPE> getAllChildren(@Nullable CHILDTYPE CHILDTYPE) {
        Collection<CHILDTYPE> collection = this.m_aChildrenProvider.getAllChildren(CHILDTYPE);
        return collection == null ? null : CollectionHelper.getSorted(collection, this.m_aComparator);
    }
}

