/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.lang.CGStringHelper;
import com.helger.commons.scopes.AbstractMapBasedScope;
import com.helger.commons.scopes.MetaScopeFactory;
import com.helger.commons.scopes.ScopeUtils;
import com.helger.commons.scopes.domain.ISessionApplicationScope;
import com.helger.commons.scopes.domain.ISessionScope;
import com.helger.commons.scopes.spi.ScopeSPIManager;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionScope
extends AbstractMapBasedScope
implements ISessionScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SessionScope.class);
    private final Map<String, ISessionApplicationScope> m_aSessionAppScopes = new HashMap<String, ISessionApplicationScope>();

    public SessionScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeUtils.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created session scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void destroyOwnedScopes() {
        this.m_aRWLock.writeLock().lock();
        try {
            for (ISessionApplicationScope iSessionApplicationScope : this.m_aSessionAppScopes.values()) {
                ScopeSPIManager.onSessionApplicationScopeEnd(iSessionApplicationScope);
                iSessionApplicationScope.destroyScope();
            }
            this.m_aSessionAppScopes.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    protected void preDestroy() {
        if (ScopeUtils.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying session scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeUtils.debugSessionScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed session scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    public EContinue selfDestruct() {
        return EContinue.CONTINUE;
    }

    @Nonnull
    @Nonempty
    private String _getApplicationScopeIDPrefix() {
        return this.getID() + '.';
    }

    @Override
    @Nonnull
    @Nonempty
    public String createApplicationScopeID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ApplicationID");
        return this._getApplicationScopeIDPrefix() + string;
    }

    @Override
    @Nullable
    public String getApplicationIDFromApplicationScopeID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = this._getApplicationScopeIDPrefix();
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return null;
    }

    @Nonnull
    protected ISessionApplicationScope createSessionApplicationScope(@Nonnull @Nonempty String string) {
        return MetaScopeFactory.getScopeFactory().createSessionApplicationScope(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ISessionApplicationScope getSessionApplicationScope(@Nonnull @Nonempty String string, boolean bl) {
        ISessionApplicationScope iSessionApplicationScope;
        ValueEnforcer.notEmpty(string, "ApplicationID");
        String string2 = this.createApplicationScopeID(string);
        this.m_aRWLock.readLock().lock();
        try {
            iSessionApplicationScope = this.m_aSessionAppScopes.get(string2);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (iSessionApplicationScope == null && bl) {
            this.m_aRWLock.writeLock().lock();
            try {
                iSessionApplicationScope = this.m_aSessionAppScopes.get(string2);
                if (iSessionApplicationScope == null) {
                    iSessionApplicationScope = this.createSessionApplicationScope(string2);
                    this.m_aSessionAppScopes.put(string2, iSessionApplicationScope);
                    iSessionApplicationScope.initScope();
                    ScopeSPIManager.onSessionApplicationScopeBegin(iSessionApplicationScope);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return iSessionApplicationScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreSessionApplicationScope(@Nonnull @Nonempty String string, @Nonnull ISessionApplicationScope iSessionApplicationScope) {
        ValueEnforcer.notEmpty(string, "ScopeID");
        ValueEnforcer.notNull(iSessionApplicationScope, "Scope");
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aSessionAppScopes.containsKey(string)) {
                throw new IllegalArgumentException("A session application scope with the ID '" + string + "' is already contained!");
            }
            this.m_aSessionAppScopes.put(string, iSessionApplicationScope);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, ISessionApplicationScope> getAllSessionApplicationScopes() {
        this.m_aRWLock.readLock().lock();
        try {
            Map<String, ISessionApplicationScope> map = CollectionHelper.newMap(this.m_aSessionAppScopes);
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int getSessionApplicationScopeCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aSessionAppScopes.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("sessionAppScopes", this.m_aSessionAppScopes).toString();
    }
}

