/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.io;

import com.helger.commons.annotations.UsedViaReflection;
import com.helger.commons.io.monitor.FileMonitor;
import com.helger.commons.io.monitor.FileMonitorManager;
import com.helger.commons.io.monitor.IFileListener;
import com.helger.commons.scopes.IScope;
import com.helger.commons.scopes.singleton.GlobalSingleton;
import com.helger.commons.state.EChange;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScopedFileMonitorManager
extends GlobalSingleton {
    private final FileMonitorManager m_aFMM = new FileMonitorManager();

    @Deprecated
    @UsedViaReflection
    public ScopedFileMonitorManager() {
        this.m_aFMM.start();
    }

    @Nonnull
    public static ScopedFileMonitorManager getInstance() {
        return ScopedFileMonitorManager.getGlobalSingleton(ScopedFileMonitorManager.class);
    }

    @Override
    protected void onDestroy(@Nonnull IScope iScope) {
        this.m_aFMM.stop();
    }

    @Nonnull
    public EChange start() {
        if (this.isRunning()) {
            return EChange.UNCHANGED;
        }
        this.m_aFMM.start();
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange stop() {
        if (!this.isRunning()) {
            return EChange.UNCHANGED;
        }
        this.m_aFMM.stop();
        return EChange.CHANGED;
    }

    public boolean isRunning() {
        return this.m_aFMM.isRunning();
    }

    public long getDelay() {
        return this.m_aFMM.getDelay();
    }

    public void setDelay(long l) {
        this.m_aFMM.setDelay(l);
    }

    public int getChecksPerRun() {
        return this.m_aFMM.getChecksPerRun();
    }

    public void setChecksPerRun(int n) {
        this.m_aFMM.setChecksPerRun(n);
    }

    @Nonnull
    public FileMonitor createFileMonitor(@Nonnull IFileListener iFileListener) {
        return this.m_aFMM.createFileMonitor(iFileListener);
    }

    public void addFileMonitor(@Nonnull FileMonitor fileMonitor) {
        this.m_aFMM.addFileMonitor(fileMonitor);
    }

    @Nonnull
    public EChange removeFileMonitor(@Nullable FileMonitor fileMonitor) {
        return this.m_aFMM.removeFileMonitor(fileMonitor);
    }
}

