/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.singleton;

import com.helger.commons.scopes.AbstractSingleton;
import com.helger.commons.scopes.domain.IGlobalScope;
import com.helger.commons.scopes.mgr.ScopeManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class GlobalSingleton
extends AbstractSingleton {
    protected GlobalSingleton() {
    }

    @Nonnull
    private static IGlobalScope _getStaticScope(boolean bl) {
        return bl ? ScopeManager.getGlobalScope() : ScopeManager.getGlobalScopeOrNull();
    }

    @Nonnull
    public static final <T extends GlobalSingleton> T getGlobalSingleton(@Nonnull Class<T> clazz) {
        return (T)((GlobalSingleton)GlobalSingleton.getSingleton(GlobalSingleton._getStaticScope(true), clazz));
    }

    @Nullable
    public static final <T extends GlobalSingleton> T getGlobalSingletonIfInstantiated(@Nonnull Class<T> clazz) {
        return (T)((GlobalSingleton)GlobalSingleton.getSingletonIfInstantiated(GlobalSingleton._getStaticScope(false), clazz));
    }

    public static final boolean isGlobalSingletonInstantiated(@Nonnull Class<? extends GlobalSingleton> clazz) {
        return GlobalSingleton.isSingletonInstantiated(GlobalSingleton._getStaticScope(false), clazz);
    }

    @Nonnull
    public static final List<GlobalSingleton> getAllGlobalSingletons() {
        return GlobalSingleton.getAllSingletons(GlobalSingleton._getStaticScope(false), GlobalSingleton.class);
    }
}

