/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.spi;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.mock.IMockException;
import com.helger.commons.scopes.domain.IApplicationScope;
import com.helger.commons.scopes.domain.IGlobalScope;
import com.helger.commons.scopes.domain.IRequestScope;
import com.helger.commons.scopes.domain.ISessionApplicationScope;
import com.helger.commons.scopes.domain.ISessionScope;
import com.helger.commons.scopes.spi.IApplicationScopeSPI;
import com.helger.commons.scopes.spi.IGlobalScopeSPI;
import com.helger.commons.scopes.spi.IRequestScopeSPI;
import com.helger.commons.scopes.spi.ISessionApplicationScopeSPI;
import com.helger.commons.scopes.spi.ISessionScopeSPI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ScopeSPIManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ScopeSPIManager.class);
    private static final List<IGlobalScopeSPI> s_aGlobalSPIs = ServiceLoaderUtils.getAllSPIImplementations(IGlobalScopeSPI.class);
    private static final List<IApplicationScopeSPI> s_aApplicationSPIs = ServiceLoaderUtils.getAllSPIImplementations(IApplicationScopeSPI.class);
    private static final List<ISessionScopeSPI> s_aSessionSPIs = ServiceLoaderUtils.getAllSPIImplementations(ISessionScopeSPI.class);
    private static final List<ISessionApplicationScopeSPI> s_aSessionApplicationSPIs = ServiceLoaderUtils.getAllSPIImplementations(ISessionApplicationScopeSPI.class);
    private static final List<IRequestScopeSPI> s_aRequestSPIs = ServiceLoaderUtils.getAllSPIImplementations(IRequestScopeSPI.class);
    private static final ScopeSPIManager s_aInstance = new ScopeSPIManager();

    private ScopeSPIManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<IGlobalScopeSPI> getAllGlobalScopeSPIs() {
        return CollectionHelper.newList(s_aGlobalSPIs);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<IApplicationScopeSPI> getAllApplicationScopeSPIs() {
        return CollectionHelper.newList(s_aApplicationSPIs);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<ISessionScopeSPI> getAllSessionScopeSPIs() {
        return CollectionHelper.newList(s_aSessionSPIs);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<ISessionApplicationScopeSPI> getAllSessionApplicationScopeSPIs() {
        return CollectionHelper.newList(s_aSessionApplicationSPIs);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<IRequestScopeSPI> getAllRequestScopeSPIs() {
        return CollectionHelper.newList(s_aRequestSPIs);
    }

    public static void onGlobalScopeBegin(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : s_aGlobalSPIs) {
            try {
                iGlobalScopeSPI.onGlobalScopeBegin(iGlobalScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onGlobalScopeBegin on " + iGlobalScopeSPI + " with scope " + iGlobalScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onGlobalScopeEnd(@Nonnull IGlobalScope iGlobalScope) {
        for (IGlobalScopeSPI iGlobalScopeSPI : s_aGlobalSPIs) {
            try {
                iGlobalScopeSPI.onGlobalScopeEnd(iGlobalScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onGlobalScopeEnd on " + iGlobalScopeSPI + " with scope " + iGlobalScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onApplicationScopeBegin(@Nonnull IApplicationScope iApplicationScope) {
        for (IApplicationScopeSPI iApplicationScopeSPI : s_aApplicationSPIs) {
            try {
                iApplicationScopeSPI.onApplicationScopeBegin(iApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onApplicationScopeBegin on " + iApplicationScopeSPI + " with scope " + iApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onApplicationScopeEnd(@Nonnull IApplicationScope iApplicationScope) {
        for (IApplicationScopeSPI iApplicationScopeSPI : s_aApplicationSPIs) {
            try {
                iApplicationScopeSPI.onApplicationScopeEnd(iApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onApplicationScopeEnd on " + iApplicationScopeSPI + " with scope " + iApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onSessionScopeBegin(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : s_aSessionSPIs) {
            try {
                iSessionScopeSPI.onSessionScopeBegin(iSessionScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionScopeBegin on " + iSessionScopeSPI + " with scope " + iSessionScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onSessionScopeEnd(@Nonnull ISessionScope iSessionScope) {
        for (ISessionScopeSPI iSessionScopeSPI : s_aSessionSPIs) {
            try {
                iSessionScopeSPI.onSessionScopeEnd(iSessionScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionScopeEnd on " + iSessionScopeSPI + " with scope " + iSessionScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onSessionApplicationScopeBegin(@Nonnull ISessionApplicationScope iSessionApplicationScope) {
        for (ISessionApplicationScopeSPI iSessionApplicationScopeSPI : s_aSessionApplicationSPIs) {
            try {
                iSessionApplicationScopeSPI.onSessionApplicationScopeBegin(iSessionApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionApplicationScopeBegin on " + iSessionApplicationScopeSPI + " with scope " + iSessionApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onSessionApplicationScopeEnd(@Nonnull ISessionApplicationScope iSessionApplicationScope) {
        for (ISessionApplicationScopeSPI iSessionApplicationScopeSPI : s_aSessionApplicationSPIs) {
            try {
                iSessionApplicationScopeSPI.onSessionApplicationScopeEnd(iSessionApplicationScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onSessionApplicationScopeEnd on " + iSessionApplicationScopeSPI + " with scope " + iSessionApplicationScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onRequestScopeBegin(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : s_aRequestSPIs) {
            try {
                iRequestScopeSPI.onRequestScopeBegin(iRequestScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onRequestScopeBegin on " + iRequestScopeSPI + " with scope " + iRequestScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }

    public static void onRequestScopeEnd(@Nonnull IRequestScope iRequestScope) {
        for (IRequestScopeSPI iRequestScopeSPI : s_aRequestSPIs) {
            try {
                iRequestScopeSPI.onRequestScopeEnd(iRequestScope);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke SPI method onRequestScopeEnd on " + iRequestScopeSPI + " with scope " + iRequestScope, throwable instanceof IMockException ? null : throwable);
            }
        }
    }
}

