/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.stats;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.stats.IStatisticsHandlerKeyedCounter;
import com.helger.commons.string.ToStringGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class StatisticsHandlerKeyedCounter
implements IStatisticsHandlerKeyedCounter {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final Map<String, Value> m_aMap = new HashMap<String, Value>();

    StatisticsHandlerKeyedCounter() {
    }

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    public void increment(@Nullable String string) {
        this.increment(string, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            if (value == null) {
                this.m_aMap.put(string, new Value(l));
            } else {
                value.increment(l);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllKeys() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = CollectionHelper.newSet(this.m_aMap.keySet());
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public long getCount(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            long l = value == null ? -1L : value.getCount();
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public int getInvocationCount(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            int n = value == null ? -1 : value.getInvocationCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        this.m_aRWLock.readLock().lock();
        try {
            String string = "invocations=" + this.getInvocationCount() + "; keyed=" + this.m_aMap.entrySet();
            return string;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @NotThreadSafe
    private static final class Value {
        private int m_nInvocationCount = 1;
        private long m_nCount;

        public Value(long l) {
            this.m_nCount = l;
        }

        public void increment(long l) {
            ++this.m_nInvocationCount;
            this.m_nCount += l;
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        public long getCount() {
            return this.m_nCount;
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("count", this.m_nCount).toString();
        }
    }
}

