/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.text.resource.XMLResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public final class XMLResourceBundleControl
extends ResourceBundle.Control {
    private static final String FORMAT_XML = "xml";
    private static final List<String> FORMATS = CollectionHelper.newList("xml");

    @Override
    @ReturnsMutableCopy
    public List<String> getFormats(@Nonnull String string) {
        ValueEnforcer.notNull(string, "BaseName");
        return CollectionHelper.newList(FORMATS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(@Nonnull String string, @Nonnull Locale locale, @Nonnull String string2, @Nonnull ClassLoader classLoader, boolean bl) throws IOException {
        String string3;
        String string4;
        URL uRL;
        ValueEnforcer.notNull(string, "BaseName");
        ValueEnforcer.notNull(locale, "Locale");
        ValueEnforcer.notNull(string2, "Format");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        if (string2.equals(FORMAT_XML) && (uRL = classLoader.getResource(string4 = this.toResourceName(string3 = this.toBundleName(string, locale), string2))) != null) {
            InputStream inputStream = StreamUtils.getBuffered(URLResource.getInputStream(uRL));
            try {
                XMLResourceBundle xMLResourceBundle = new XMLResourceBundle(inputStream);
                return xMLResourceBundle;
            }
            finally {
                StreamUtils.close(inputStream);
            }
        }
        return null;
    }
}

