/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.thirdparty;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.state.EChange;
import com.helger.commons.thirdparty.IThirdPartyModule;
import com.helger.commons.thirdparty.IThirdPartyModuleProviderSPI;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThirdPartyModuleRegistry {
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Set<IThirdPartyModule> m_aModules = new LinkedHashSet<IThirdPartyModule>();

    private ThirdPartyModuleRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ThirdPartyModuleRegistry getInstance() {
        s_bDefaultInstantiated = true;
        return SingletonHolder.s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange registerThirdPartyModule(@Nonnull IThirdPartyModule iThirdPartyModule) {
        ValueEnforcer.notNull(iThirdPartyModule, "Module");
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aModules.add(iThirdPartyModule));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Set<IThirdPartyModule> getAllRegisteredThirdPartyModules() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<IThirdPartyModule> set = CollectionHelper.newSet(this.m_aModules);
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getRegisteredThirdPartyModuleCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aModules.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aModules.clear();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        for (IThirdPartyModuleProviderSPI iThirdPartyModuleProviderSPI : ServiceLoaderUtils.getAllSPIImplementations(IThirdPartyModuleProviderSPI.class)) {
            IThirdPartyModule[] iThirdPartyModuleArray = iThirdPartyModuleProviderSPI.getAllThirdPartyModules();
            if (iThirdPartyModuleArray == null) continue;
            for (IThirdPartyModule iThirdPartyModule : iThirdPartyModuleArray) {
                this.registerThirdPartyModule(iThirdPartyModule);
            }
        }
    }

    private static final class SingletonHolder {
        static final ThirdPartyModuleRegistry s_aInstance = new ThirdPartyModuleRegistry();

        private SingletonHolder() {
        }
    }
}

