/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.encode.IDecoder;
import com.helger.commons.encode.IEncoder;
import com.helger.commons.encode.IdentityDecoder;
import com.helger.commons.encode.IdentityEncoder;
import com.helger.commons.exceptions.InitializationException;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.microdom.reader.XMLMapHandler;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mutable.IWrapper;
import com.helger.commons.mutable.Wrapper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLData;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.commons.url.encode.URLParameterEncoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class URLUtils {
    public static final String CHARSET_URL = "UTF-8";
    public static final Charset CHARSET_URL_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final char QUESTIONMARK = '?';
    public static final String QUESTIONMARK_STR = Character.toString('?');
    public static final char AMPERSAND = '&';
    public static final String AMPERSAND_STR = Character.toString('&');
    public static final char EQUALS = '=';
    public static final String EQUALS_STR = Character.toString('=');
    public static final char HASH = '#';
    public static final String HASH_STR = Character.toString('#');
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLUtils.class);
    private static char[] s_aCleanURLOld;
    private static char[][] s_aCleanURLNew;
    private static final URLUtils s_aInstance;

    private URLUtils() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string) {
        return URLUtils.urlDecode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return URLUtils.urlDecode(string, charset.name());
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLDecoder.decode(string);
        }
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string) {
        return URLUtils.urlEncode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return URLUtils.urlEncode(string, charset.name());
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLEncoder.encode(string);
        }
    }

    private static void _initCleanURL() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/cleanurl-data.xml"), hashMap).isFailure()) {
            throw new InitializationException("Failed to init CleanURL data!");
        }
        s_aCleanURLOld = new char[hashMap.size()];
        s_aCleanURLNew = new char[hashMap.size()][];
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + string.length());
            }
            URLUtils.s_aCleanURLOld[n] = string.charAt(0);
            URLUtils.s_aCleanURLNew[n] = ((String)entry.getValue()).toCharArray();
            ++n;
        }
    }

    @Nullable
    public static String getCleanURLPartWithoutUmlauts(@Nullable String string) {
        if (s_aCleanURLOld == null) {
            URLUtils._initCleanURL();
        }
        char[] cArray = StringHelper.replaceMultiple(string, s_aCleanURLOld, s_aCleanURLNew);
        return new String(cArray);
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string) {
        return URLUtils.getAsURLData(string, IdentityDecoder.<String>create());
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string, @Nonnull IDecoder<String> iDecoder) {
        String string2;
        String string3;
        ValueEnforcer.notNull(string, "Href");
        ValueEnforcer.notNull(iDecoder, "ParameterDecoder");
        String string4 = string.trim();
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string4);
        if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
            return new URLData(string4, null, null);
        }
        if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
            try {
                new URL(string4);
            }
            catch (MalformedURLException malformedURLException) {
                s_aLogger.warn("java.net.URL claims URL '" + string4 + "' to be invalid: " + malformedURLException.getMessage());
            }
        }
        Map<String, String> map = null;
        String string5 = string4;
        int n = string5.indexOf(35);
        if (n >= 0) {
            string3 = string5.substring(n + 1).trim();
            string5 = string5.substring(0, n).trim();
        } else {
            string3 = null;
        }
        int n2 = string5.indexOf(63);
        if (n2 >= 0) {
            String string6 = string5.substring(n2 + 1).trim();
            if (StringHelper.hasText(string6)) {
                map = URLUtils._getQueryStringAsMap(string6, iDecoder);
            }
            string2 = string5.substring(0, n2).trim();
        } else {
            string2 = string5;
        }
        return new URLData(string2, map, string3);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static Map<String, String> _getQueryStringAsMap(@Nullable String string, @Nonnull IDecoder<String> iDecoder) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (StringHelper.hasText(string)) {
            for (String string2 : StringHelper.getExploded('&', string)) {
                String string3;
                List<String> list;
                String string4;
                if (string2.length() <= 0 || !StringHelper.hasText(string4 = (list = StringHelper.getExploded('=', string2, 2)).get(0))) continue;
                String string5 = string3 = list.size() == 2 ? list.get(1) : "";
                if (string3 == null) {
                    throw new NullPointerException("parameter value may not be null");
                }
                linkedHashMap.put(iDecoder.decode(string4), iDecoder.decode(string3));
            }
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getQueryStringAsMap(@Nullable String string) {
        return URLUtils._getQueryStringAsMap(string, IdentityDecoder.<String>create());
    }

    @Nonnull
    @Deprecated
    public static String getURLString(@Nonnull IURLData iURLData, @Nullable String string) {
        return URLUtils.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), string);
    }

    @Nonnull
    public static String getURLString(@Nonnull IURLData iURLData, @Nullable Charset charset) {
        return URLUtils.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), charset);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nonnull IEncoder<String> iEncoder) {
        ValueEnforcer.notNull(iEncoder, "ParameterEncoder");
        boolean bl = CollectionHelper.isNotEmpty(map);
        boolean bl2 = StringHelper.hasText(string2);
        if (!bl && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
        }
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = stringBuilder.indexOf(QUESTIONMARK_STR) >= 0;
            if (bl3) {
                char c = StringHelper.getLastChar(stringBuilder);
                if (c != '?' && c != '&') {
                    stringBuilder.append('&');
                }
            } else {
                stringBuilder.append('?');
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                stringBuilder.append(iEncoder.encode(string3));
                String string4 = entry.getValue();
                if (StringHelper.hasText(string4)) {
                    stringBuilder.append('=').append(iEncoder.encode(string4));
                }
                stringBuilder.append('&');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (bl2) {
            if (StringHelper.getLastChar(stringBuilder) != '#') {
                stringBuilder.append('#');
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0) {
            return QUESTIONMARK_STR;
        }
        return stringBuilder.toString();
    }

    @Nullable
    @Deprecated
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable String string3) {
        return URLUtils.getURLString(string, map, string2, string3 == null ? null : CharsetManager.getCharsetFromName(string3));
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable Charset charset) {
        IEncoder iEncoder = charset == null ? IdentityEncoder.create() : new URLParameterEncoder(charset);
        return URLUtils.getURLString(string, map, string2, iEncoder);
    }

    @Nullable
    public static URL getAsURL(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getAsURL(@Nullable URI uRI) {
        if (uRI != null) {
            try {
                return uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable URL uRL) {
        if (uRL != null) {
            try {
                return uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL, int n, int n2, @Nullable INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter, @Nullable IWrapper<IOException> iWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            URLConnection uRLConnection = uRL.openConnection();
            if (n >= 0) {
                uRLConnection.setConnectTimeout(n);
            }
            if (n2 >= 0) {
                uRLConnection.setReadTimeout(n2);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                httpURLConnection = (HttpURLConnection)uRLConnection;
            }
            uRLConnection.setUseCaches(false);
            if (iNonThrowingRunnableWithParameter != null) {
                iNonThrowingRunnableWithParameter.run(uRLConnection);
            }
            if (uRLConnection instanceof JarURLConnection && (object = ((JarURLConnection)uRLConnection).getJarEntry()) != null) {
                if (((ZipEntry)object).isDirectory()) {
                    return null;
                }
                if (((ZipEntry)object).getSize() == 0L && ((ZipEntry)object).getCrc() == 0L) {
                    s_aLogger.warn("Heuristically determined " + uRL + " to be a directory!");
                    return null;
                }
            }
            object = uRLConnection.getInputStream();
            return object;
        }
        catch (IOException iOException) {
            if (iWrapper != null) {
                iWrapper.set(iOException);
            } else if (iOException instanceof SocketTimeoutException) {
                s_aLogger.warn("Timeout to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            } else {
                s_aLogger.warn("Failed to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
            if (httpURLConnection != null) {
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getErrorStream();
                    if (inputStream != null) {
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                }
                catch (IOException iOException2) {
                    s_aLogger.warn("Failed to consume error stream for '" + uRL + "': " + iOException2.getClass().getName() + " - " + iOException2.getMessage());
                }
                finally {
                    StreamUtils.close(inputStream);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream postAndGetInputStream(final @Nonnull URL uRL, int n, int n2, final @Nullable IMimeType iMimeType, final @Nonnull byte[] byArray, final @Nullable Map<String, String> map, final @Nullable INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter, @Nullable IWrapper<IOException> iWrapper) {
        ValueEnforcer.notNull(uRL, "URL");
        ValueEnforcer.notNull(byArray, "ContentBytes");
        final Wrapper wrapper = new Wrapper();
        INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter2 = new INonThrowingRunnableWithParameter<URLConnection>(){

            @Override
            public void run(@Nonnull URLConnection uRLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                try {
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(true);
                    if (iMimeType != null) {
                        httpURLConnection.setRequestProperty("Content-Type", iMimeType.getAsString());
                    }
                    httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    OutputStream outputStream = httpURLConnection.getOutputStream();
                    wrapper.set(outputStream);
                    outputStream.write(byArray);
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Failed to POST data to " + uRL.toExternalForm(), iOException);
                }
                if (iNonThrowingRunnableWithParameter != null) {
                    iNonThrowingRunnableWithParameter.run(uRLConnection);
                }
            }
        };
        try {
            InputStream inputStream = URLUtils.getInputStream(uRL, n, n2, iNonThrowingRunnableWithParameter2, iWrapper);
            return inputStream;
        }
        finally {
            StreamUtils.close((Closeable)wrapper.get());
        }
    }

    @Nonnull
    public static String getApplicationFormEncoded(@Nullable Map<String, String> map, @Nonnull IEncoder<String> iEncoder) {
        ValueEnforcer.notNull(iEncoder, "ParameterEncoder");
        if (CollectionHelper.isEmpty(map)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                String string = entry.getKey();
                stringBuilder.append(iEncoder.encode(string));
                String string2 = entry.getValue();
                if (!StringHelper.hasText(string2)) continue;
                stringBuilder.append('=').append(iEncoder.encode(string2));
            }
        }
        return stringBuilder.toString();
    }

    static {
        s_aInstance = new URLUtils();
    }
}

