/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize;

import com.helger.commons.CGlobal;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.callback.LoggingExceptionHandler;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.xml.sax.AbstractSAXErrorHandler;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoggingExceptionHandler
extends LoggingExceptionHandler {
    public XMLLoggingExceptionHandler() {
    }

    public XMLLoggingExceptionHandler(@Nonnull EErrorLevel eErrorLevel) {
        super(eErrorLevel);
    }

    @Override
    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getLogMessage(@Nullable Throwable throwable) {
        if (throwable instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)throwable;
            return AbstractSAXErrorHandler.getSaxParseError(EErrorLevel.ERROR, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
        }
        if (throwable instanceof SAXException) {
            return "Error parsing XML document";
        }
        if (throwable instanceof UnknownHostException) {
            return "Failed to resolve entity host: " + throwable.getMessage();
        }
        if (throwable instanceof IOException) {
            return "Error reading XML document: " + throwable.getMessage();
        }
        return super.getLogMessage(throwable);
    }

    @Override
    protected boolean isLogException(@Nullable Throwable throwable) {
        if (throwable instanceof UnknownHostException) {
            return false;
        }
        return super.isLogException(throwable);
    }
}

