/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.aggregate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.aggregate.IAggregator;
import com.helger.commons.aggregate.IAggregatorFactory;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AggregatorFactoryNewInstance<SRCTYPE, DSTTYPE>
implements IAggregatorFactory<SRCTYPE, DSTTYPE> {
    private final Class<? extends IAggregator<?, ?>> m_aClass;

    public <DATATYPE extends IAggregator<?, ?>> AggregatorFactoryNewInstance(@Nonnull Class<DATATYPE> clazz) {
        ValueEnforcer.notNull(clazz, "aClass");
        if (!ClassHelper.isInstancableClass(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not instancable!");
        }
        this.m_aClass = clazz;
    }

    @Nonnull
    public Class<? extends IAggregator<?, ?>> getAggregatorClass() {
        return this.m_aClass;
    }

    @Override
    @Nullable
    public IAggregator<SRCTYPE, DSTTYPE> create() {
        return (IAggregator)GenericReflection.uncheckedCast(GenericReflection.newInstance(this.m_aClass));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AggregatorFactoryNewInstance aggregatorFactoryNewInstance = (AggregatorFactoryNewInstance)object;
        return this.m_aClass.equals(aggregatorFactoryNewInstance.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("class", this.m_aClass).toString();
    }
}

