/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.multimap;

import com.helger.commons.collections.multimap.IMultiMapMapBased;
import com.helger.commons.collections.multimap.MultiMapMapBasedHelper;
import com.helger.commons.state.EChange;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMultiLinkedHashMapMapBased<KEYTYPE1, KEYTYPE2, VALUETYPE>
extends LinkedHashMap<KEYTYPE1, Map<KEYTYPE2, VALUETYPE>>
implements IMultiMapMapBased<KEYTYPE1, KEYTYPE2, VALUETYPE> {
    public AbstractMultiLinkedHashMapMapBased() {
    }

    public AbstractMultiLinkedHashMapMapBased(@Nullable KEYTYPE1 KEYTYPE1, @Nullable KEYTYPE2 KEYTYPE2, @Nullable VALUETYPE VALUETYPE) {
        this.putSingle(KEYTYPE1, KEYTYPE2, VALUETYPE);
    }

    public AbstractMultiLinkedHashMapMapBased(@Nullable KEYTYPE1 KEYTYPE1, @Nullable Map<KEYTYPE2, VALUETYPE> map) {
        this.put(KEYTYPE1, map);
    }

    public AbstractMultiLinkedHashMapMapBased(@Nullable Map<? extends KEYTYPE1, ? extends Map<KEYTYPE2, VALUETYPE>> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    @Nonnull
    protected abstract Map<KEYTYPE2, VALUETYPE> createNewInnerMap();

    @Override
    @Nonnull
    public Map<KEYTYPE2, VALUETYPE> getOrCreate(@Nullable KEYTYPE1 KEYTYPE1) {
        Map<KEYTYPE2, VALUETYPE> map = (Map<KEYTYPE2, VALUETYPE>)this.get(KEYTYPE1);
        if (map == null) {
            map = this.createNewInnerMap();
            super.put(KEYTYPE1, map);
        }
        return map;
    }

    @Override
    @Nonnull
    public final EChange putSingle(@Nullable KEYTYPE1 KEYTYPE1, @Nullable KEYTYPE2 KEYTYPE2, @Nullable VALUETYPE VALUETYPE) {
        return EChange.valueOf(this.getOrCreate(KEYTYPE1).put(KEYTYPE2, VALUETYPE) != null);
    }

    @Override
    @Nonnull
    public final EChange putAllIn(@Nonnull Map<? extends KEYTYPE1, ? extends Map<KEYTYPE2, VALUETYPE>> map) {
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry<KEYTYPE1, Map<KEYTYPE2, VALUETYPE>> entry : map.entrySet()) {
            for (Map.Entry<KEYTYPE2, VALUETYPE> entry2 : entry.getValue().entrySet()) {
                eChange = eChange.or(this.putSingle(entry.getKey(), entry2.getKey(), entry2.getValue()));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange removeSingle(@Nullable KEYTYPE1 KEYTYPE1, @Nullable KEYTYPE2 KEYTYPE2) {
        Map map = (Map)this.get(KEYTYPE1);
        return map == null ? EChange.UNCHANGED : EChange.valueOf(map.remove(KEYTYPE2) != null);
    }

    @Override
    public final boolean containsSingle(@Nullable KEYTYPE1 KEYTYPE1, @Nullable KEYTYPE2 KEYTYPE2) {
        Map map = (Map)this.get(KEYTYPE1);
        return map != null && map.containsKey(KEYTYPE2);
    }

    @Override
    @Nonnegative
    public final long getTotalValueCount() {
        return MultiMapMapBasedHelper.getTotalValueCount(this);
    }
}

