/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.INonThrowingRunnable;
import com.helger.commons.concurrent.collector.IConcurrentCollector;
import com.helger.commons.state.ESuccess;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConcurrentCollector<DATATYPE>
implements INonThrowingRunnable,
IConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 100;
    protected static final Object STOP_QUEUE_OBJECT = new Object();
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractConcurrentCollector.class);
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    protected final BlockingQueue<Object> m_aQueue;
    private boolean m_bStopTakingNewObjects = false;

    public AbstractConcurrentCollector(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "MaxQueueSize");
        this.m_aQueue = new ArrayBlockingQueue<Object>(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final ESuccess queueObject(@Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.notNull(DATATYPE, "Object");
        if (this.isStopped()) {
            throw new IllegalStateException("The queue is already stopped and does not take any more elements");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aQueue.put(DATATYPE);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Failed to submit object to queue", (Throwable)interruptedException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnegative
    public final int getQueueLength() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aQueue.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public final ESuccess stopQueuingNewObjects() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aQueue.put(STOP_QUEUE_OBJECT);
            this.m_bStopTakingNewObjects = true;
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Error stopping queue", (Throwable)interruptedException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public final boolean isStopped() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_bStopTakingNewObjects;
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }
}

