/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnableWithParameter;
import com.helger.commons.concurrent.collector.AbstractConcurrentCollector;
import com.helger.commons.lang.GenericReflection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorMultiple<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_PERFORM_COUNT = 50;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorMultiple.class);
    @Nonnegative
    private final int m_nMaxPerformCount;
    private IThrowingRunnableWithParameter<List<DATATYPE>> m_aPerformer;

    public ConcurrentCollectorMultiple() {
        this(null);
    }

    public ConcurrentCollectorMultiple(@Nullable IThrowingRunnableWithParameter<List<DATATYPE>> iThrowingRunnableWithParameter) {
        this(100, 50, iThrowingRunnableWithParameter);
    }

    public ConcurrentCollectorMultiple(@Nonnegative int n, @Nonnegative int n2, @Nullable IThrowingRunnableWithParameter<List<DATATYPE>> iThrowingRunnableWithParameter) {
        super(n);
        if (n2 > n || n2 < 1) {
            throw new IllegalArgumentException("max perform size is illegal: " + n2);
        }
        this.m_nMaxPerformCount = n2;
        if (iThrowingRunnableWithParameter != null) {
            this.setPerformer(iThrowingRunnableWithParameter);
        }
    }

    protected final void setPerformer(@Nonnull IThrowingRunnableWithParameter<List<DATATYPE>> iThrowingRunnableWithParameter) {
        this.m_aPerformer = ValueEnforcer.notNull(iThrowingRunnableWithParameter, "Performer");
    }

    private void _executeCallback(@Nonnull List<DATATYPE> list) {
        if (!list.isEmpty()) {
            try {
                this.m_aPerformer.run(list);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to perform actions on " + list.size() + " objects - objects have been lost!", throwable);
            }
            list.clear();
        }
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object e;
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            while ((e = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                arrayList.add(GenericReflection.uncheckedCast(e));
                while (arrayList.size() < this.m_nMaxPerformCount && !this.m_aQueue.isEmpty()) {
                    e = this.m_aQueue.take();
                    if (e == STOP_QUEUE_OBJECT) {
                        bl = true;
                        break;
                    }
                    arrayList.add(GenericReflection.uncheckedCast(e));
                }
                this._executeCallback(arrayList);
                if (!bl) continue;
                break;
            }
            this._executeCallback(arrayList);
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", throwable);
        }
    }
}

