/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResourceErrorGroup
implements IResourceErrorGroup,
ICloneable<ResourceErrorGroup>,
IClearable {
    private final List<IResourceError> m_aErrors = new ArrayList<IResourceError>();

    public ResourceErrorGroup() {
    }

    public ResourceErrorGroup(@Nonnull IResourceError iResourceError) {
        this.addResourceError(iResourceError);
    }

    public ResourceErrorGroup(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
    }

    public ResourceErrorGroup(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
    }

    @Nonnull
    public ResourceErrorGroup addResourceError(@Nonnull IResourceError iResourceError) {
        ValueEnforcer.notNull(iResourceError, "ResourceError");
        this.m_aErrors.add(iResourceError);
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(IResourceError ... iResourceErrorArray) {
        ValueEnforcer.notNull(iResourceErrorArray, "ResourceErrors");
        for (IResourceError iResourceError : iResourceErrorArray) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrors(@Nonnull Iterable<? extends IResourceError> iterable) {
        ValueEnforcer.notNull(iterable, "ResourceErrors");
        for (IResourceError iResourceError : iterable) {
            this.addResourceError(iResourceError);
        }
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrorGroup(@Nonnull IResourceErrorGroup iResourceErrorGroup) {
        ValueEnforcer.notNull(iResourceErrorGroup, "ResourceErrorGroup");
        this.m_aErrors.addAll(iResourceErrorGroup.getAllResourceErrors());
        return this;
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoSuccess() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoFailure() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoError() {
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int n = 0;
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            ++n;
        }
        return n;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllFailures() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isFailure()) continue;
            resourceErrorGroup.addResourceError(iResourceError);
        }
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllErrors() {
        ResourceErrorGroup resourceErrorGroup = new ResourceErrorGroup();
        for (IResourceError iResourceError : this.m_aErrors) {
            if (!iResourceError.isError()) continue;
            resourceErrorGroup.addResourceError(iResourceError);
        }
        return resourceErrorGroup;
    }

    @Override
    @Nonnull
    public EErrorLevel getMostSevereErrorLevel() {
        IResourceError iResourceError;
        EErrorLevel eErrorLevel;
        EErrorLevel eErrorLevel2 = EErrorLevel.SUCCESS;
        Iterator<IResourceError> iterator = this.m_aErrors.iterator();
        while (iterator.hasNext() && (!(eErrorLevel = (iResourceError = iterator.next()).getErrorLevel()).isMoreSevereThan(eErrorLevel2) || (eErrorLevel2 = eErrorLevel) != EErrorLevel.HIGHEST)) {
        }
        return eErrorLevel2;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aErrors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getClone() {
        return new ResourceErrorGroup(this.m_aErrors);
    }

    @Override
    @Nonnull
    public Iterator<IResourceError> iterator() {
        return this.m_aErrors.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IResourceError> getAllResourceErrors() {
        return CollectionHelper.newList(this.m_aErrors);
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aErrors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aErrors.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceErrorGroup resourceErrorGroup = (ResourceErrorGroup)object;
        return this.m_aErrors.equals(resourceErrorGroup.m_aErrors);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aErrors)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("errors", this.m_aErrors).toString();
    }
}

