/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.filter.ISerializableFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SerializableFilterChainOR<DATATYPE>
implements ISerializableFilter<DATATYPE> {
    private final List<? extends ISerializableFilter<? super DATATYPE>> m_aFilters;

    public SerializableFilterChainOR(ISerializableFilter<? super DATATYPE> ... iSerializableFilterArray) {
        this.m_aFilters = CollectionHelper.newList(iSerializableFilterArray);
    }

    public SerializableFilterChainOR(@Nullable Iterable<? extends ISerializableFilter<? super DATATYPE>> iterable) {
        this.m_aFilters = CollectionHelper.newList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<? extends ISerializableFilter<? super DATATYPE>> getContainedFilters() {
        return CollectionHelper.newList(this.m_aFilters);
    }

    @Override
    public boolean matchesFilter(@Nullable DATATYPE DATATYPE) {
        for (ISerializableFilter<DATATYPE> iSerializableFilter : this.m_aFilters) {
            if (!iSerializableFilter.matchesFilter(DATATYPE)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SerializableFilterChainOR serializableFilterChainOR = (SerializableFilterChainOR)object;
        return this.m_aFilters.equals(serializableFilterChainOR.m_aFilters);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFilters)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filters", this.m_aFilters).toString();
    }

    @Nonnull
    public static <DATATYPE> SerializableFilterChainOR<DATATYPE> create(ISerializableFilter<? super DATATYPE> ... iSerializableFilterArray) {
        return new SerializableFilterChainOR<DATATYPE>(iSerializableFilterArray);
    }

    @Nonnull
    public static <DATATYPE> SerializableFilterChainOR<DATATYPE> create(@Nullable Iterable<? extends ISerializableFilter<? super DATATYPE>> iterable) {
        return new SerializableFilterChainOR<DATATYPE>(iterable);
    }
}

