/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.channels;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.mock.IMockException;
import com.helger.commons.state.ESuccess;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ChannelUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ChannelUtils.class);
    private static final boolean USE_COPY_V1 = true;
    private static final ChannelUtils s_aInstance = new ChannelUtils();

    private ChannelUtils() {
    }

    @Nonnegative
    public static long channelCopy(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        ValueEnforcer.notNull(readableByteChannel, "SourceChannel");
        if (!readableByteChannel.isOpen()) {
            throw new IllegalArgumentException("sourceChannel is not open!");
        }
        ValueEnforcer.notNull(writableByteChannel, "DestinationChannel");
        if (!writableByteChannel.isOpen()) {
            throw new IllegalArgumentException("desitnationChannel is not open!");
        }
        long l = ChannelUtils._channelCopy1(readableByteChannel, writableByteChannel);
        return l;
    }

    @Nonnegative
    private static long _channelCopy1(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            l += (long)writableByteChannel.write(byteBuffer);
            byteBuffer.compact();
        }
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            l += (long)writableByteChannel.write(byteBuffer);
        }
        return l;
    }

    private static long _channelCopy2(@Nonnull @WillNotClose ReadableByteChannel readableByteChannel, @Nonnull @WillNotClose WritableByteChannel writableByteChannel) throws IOException {
        long l = 0L;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                l += (long)writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return l;
    }

    @Nonnull
    public static ESuccess close(@Nullable Channel channel) {
        if (channel != null && channel.isOpen()) {
            return StreamUtils.close(channel);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess release(@Nullable FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.release();
                return ESuccess.SUCCESS;
            }
            catch (IOException iOException) {
                s_aLogger.error("Failed to release object " + fileLock, (Throwable)(iOException instanceof IMockException ? null : iOException));
            }
        }
        return ESuccess.FAILURE;
    }
}

