/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.UsedViaReflection;
import com.helger.commons.callback.INonThrowingCallableWithParameter;
import com.helger.commons.exceptions.LoggedRuntimeException;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.scopes.IScope;
import com.helger.commons.scopes.IScopeDestructionAware;
import com.helger.commons.stats.IStatisticsHandlerKeyedCounter;
import com.helger.commons.stats.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleton
implements IScopeDestructionAware {
    private static final int DEFAULT_KEY_LENGTH = 255;
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractSingleton.class);
    private static final IStatisticsHandlerKeyedCounter s_aStatsCounterInstantiate = StatisticsManager.getKeyedCounterHandler(AbstractSingleton.class);
    private boolean m_bInInstantiation = false;
    private boolean m_bInstantiated = false;
    private boolean m_bInDestruction = false;
    private boolean m_bDestroyed = false;

    protected final void writeAbstractSingletonFields(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.m_bInInstantiation);
        objectOutputStream.writeBoolean(this.m_bInstantiated);
        objectOutputStream.writeBoolean(this.m_bInDestruction);
        objectOutputStream.writeBoolean(this.m_bDestroyed);
    }

    protected final void readAbstractSingletonFields(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_bInInstantiation = objectInputStream.readBoolean();
        this.m_bInstantiated = objectInputStream.readBoolean();
        this.m_bInDestruction = objectInputStream.readBoolean();
        this.m_bDestroyed = objectInputStream.readBoolean();
    }

    @UsedViaReflection
    protected AbstractSingleton() {
        if (GlobalDebug.isDebugMode()) {
            boolean bl = false;
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String string = stackTraceElement.getMethodName();
                if (string.equals("getSingleton")) {
                    bl = true;
                    break;
                }
                if (!stackTraceElement.getClassName().equals(ObjectInputStream.class.getName()) || !string.equals("readOrdinaryObject")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalStateException("You cannot instantiate the class " + this.getClass().getName() + " manually! Use the method " + "getSingleton" + " instead!");
            }
        }
    }

    @OverrideOnDemand
    protected void onAfterInstantiation(@Nonnull IScope iScope) {
    }

    protected final void setInInstantiation(boolean bl) {
        this.m_bInInstantiation = bl;
    }

    public final boolean isInInstantiation() {
        return this.m_bInInstantiation;
    }

    protected final void setInstantiated(boolean bl) {
        this.m_bInstantiated = bl;
    }

    public final boolean isInstantiated() {
        return this.m_bInstantiated;
    }

    protected final void setInDestruction(boolean bl) {
        this.m_bInDestruction = bl;
    }

    public final boolean isInDestruction() {
        return this.m_bInDestruction;
    }

    protected final void setDestroyed(boolean bl) {
        this.m_bDestroyed = bl;
    }

    public final boolean isDestroyed() {
        return this.m_bDestroyed;
    }

    @OverrideOnDemand
    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
    }

    @Override
    public final void onScopeDestruction(@Nonnull IScope iScope) throws Exception {
        if (this.isInInstantiation()) {
            s_aLogger.warn("Object currently in instantiation is now destroyed: " + this.toString());
        } else if (!this.isInstantiated()) {
            s_aLogger.warn("Object not instantiated is now destroyed: " + this.toString());
        }
        if (this.isInDestruction()) {
            s_aLogger.error("Object already in destruction is now destroyed again: " + this.toString());
        } else if (this.isDestroyed()) {
            s_aLogger.error("Object already destroyed is now destroyed again: " + this.toString());
        }
        this.setInDestruction(true);
        try {
            this.onDestroy(iScope);
        }
        finally {
            this.setDestroyed(true);
            this.setInDestruction(false);
        }
    }

    public final boolean isUsableObject() {
        return this.isInstantiated() && !this.isInDestruction() && !this.isDestroyed();
    }

    @Nonnull
    public static final String getSingletonScopeKey(@Nonnull Class<? extends AbstractSingleton> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return new StringBuilder(255).append("singleton.").append(clazz.getName()).toString();
    }

    @Nullable
    public static final <T extends AbstractSingleton> T getSingletonIfInstantiated(@Nullable IScope iScope, @Nonnull Class<T> clazz) {
        AbstractSingleton abstractSingleton;
        String string;
        Object VALUETYPE;
        ValueEnforcer.notNull(clazz, "Class");
        if (iScope != null && (VALUETYPE = iScope.getAttributeObject(string = AbstractSingleton.getSingletonScopeKey(clazz))) != null && (abstractSingleton = (AbstractSingleton)clazz.cast(VALUETYPE)).isUsableObject()) {
            return (T)abstractSingleton;
        }
        return null;
    }

    public static final boolean isSingletonInstantiated(@Nullable IScope iScope, @Nonnull Class<? extends AbstractSingleton> clazz) {
        return AbstractSingleton.getSingletonIfInstantiated(iScope, clazz) != null;
    }

    @Nonnull
    private static <T extends AbstractSingleton> T _instantiateSingleton(@Nonnull Class<T> clazz, @Nonnull IScope iScope) {
        try {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Created singleton for '" + clazz + "' in scope " + iScope.toString());
            }
            if (!ClassHelper.isPublicClass(clazz)) {
                throw new IllegalStateException("Class " + clazz + " is not instancable!");
            }
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(IScope.class);
                AbstractSingleton abstractSingleton = (AbstractSingleton)constructor.newInstance(iScope);
                return (T)abstractSingleton;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<T> constructor = clazz.getDeclaredConstructor(null);
                AbstractSingleton abstractSingleton = (AbstractSingleton)constructor.newInstance(null);
                return (T)abstractSingleton;
            }
        }
        catch (Throwable throwable) {
            throw LoggedRuntimeException.newException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final <T extends AbstractSingleton> T getSingleton(final @Nonnull IScope iScope, final @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(iScope, "aScope");
        ValueEnforcer.notNull(clazz, "Class");
        final String string = AbstractSingleton.getSingletonScopeKey(clazz);
        AbstractSingleton abstractSingleton = (AbstractSingleton)clazz.cast(iScope.getAttributeObject(string));
        if (abstractSingleton == null) {
            final MutableBoolean mutableBoolean = new MutableBoolean(false);
            abstractSingleton = (AbstractSingleton)iScope.runAtomic(new INonThrowingCallableWithParameter<T, IScope>(){

                @Override
                @Nonnull
                public T call(@Nullable IScope iScope2) {
                    AbstractSingleton abstractSingleton = (AbstractSingleton)clazz.cast(iScope.getAttributeObject(string));
                    if (abstractSingleton == null) {
                        abstractSingleton = AbstractSingleton._instantiateSingleton(clazz, iScope);
                        iScope.setAttribute(string, abstractSingleton);
                        mutableBoolean.set(true);
                        s_aStatsCounterInstantiate.increment(string);
                    }
                    return abstractSingleton;
                }
            });
            if (mutableBoolean.booleanValue()) {
                abstractSingleton.setInInstantiation(true);
                try {
                    abstractSingleton.onAfterInstantiation(iScope);
                    abstractSingleton.setInstantiated(true);
                }
                finally {
                    abstractSingleton.setInInstantiation(false);
                }
            }
        }
        return (T)abstractSingleton;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static final <T extends AbstractSingleton> List<T> getAllSingletons(@Nullable IScope iScope, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, "DesiredClass");
        ArrayList<T> arrayList = new ArrayList<T>();
        if (iScope != null) {
            for (Object VALUETYPE : iScope.getAllAttributeValues()) {
                if (VALUETYPE == null || !clazz.isAssignableFrom(VALUETYPE.getClass())) continue;
                arrayList.add(clazz.cast(VALUETYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    public String toString() {
        return new ToStringGenerator(this).append("InInstantiation", this.m_bInInstantiation).append("Instantiated", this.m_bInstantiated).append("InDestruction", this.m_bInDestruction).append("Destroyed", this.m_bDestroyed).toString();
    }
}

