/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.scopes.factory.DefaultScopeFactory;
import com.helger.commons.scopes.factory.IScopeFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetaScopeFactory {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IScopeFactory s_aScopeFactory = new DefaultScopeFactory();

    private MetaScopeFactory() {
    }

    public static void setScopeFactory(@Nonnull IScopeFactory iScopeFactory) {
        ValueEnforcer.notNull(iScopeFactory, "ScopeFactory");
        s_aRWLock.writeLock().lock();
        try {
            s_aScopeFactory = iScopeFactory;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    public static IScopeFactory getScopeFactory() {
        s_aRWLock.readLock().lock();
        try {
            IScopeFactory iScopeFactory = s_aScopeFactory;
            return iScopeFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }
}

