/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.mgr;

import com.helger.commons.scopes.IScope;
import com.helger.commons.scopes.mgr.ScopeManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EScope {
    GLOBAL,
    APPLICATION,
    SESSION,
    SESSION_APPLICATION,
    REQUEST;


    @Nonnull
    public IScope getScope() {
        return this.getScope(true);
    }

    @Nullable
    public IScope getScope(boolean bl) {
        return EScope.getScope(this, bl);
    }

    @Nullable
    public static IScope getScope(@Nonnull EScope eScope, boolean bl) {
        switch (eScope) {
            case GLOBAL: {
                return bl ? ScopeManager.getGlobalScope() : ScopeManager.getGlobalScopeOrNull();
            }
            case APPLICATION: {
                return ScopeManager.getApplicationScope(bl);
            }
            case SESSION: {
                return ScopeManager.getSessionScope(bl);
            }
            case SESSION_APPLICATION: {
                return ScopeManager.getSessionApplicationScope(bl);
            }
            case REQUEST: {
                return bl ? ScopeManager.getRequestScope() : ScopeManager.getRequestScopeOrNull();
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + (Object)((Object)eScope));
    }
}

