/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.callback.INonThrowingCallable;
import com.helger.commons.scopes.mgr.ScopeManager;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractScopeAwareCallable<DATATYPE>
implements INonThrowingCallable<DATATYPE> {
    private final String m_sApplicationID;
    private final String m_sRequestID;
    private final String m_sSessionID;

    public AbstractScopeAwareCallable() {
        this(ScopeManager.getApplicationScope().getID());
    }

    public AbstractScopeAwareCallable(@Nonnull @Nonempty String string) {
        this(string, "mock.request", "mock.session");
    }

    public AbstractScopeAwareCallable(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this.m_sApplicationID = ValueEnforcer.notEmpty(string, "ApplicationID");
        this.m_sRequestID = ValueEnforcer.notEmpty(string2, "RequestID");
        this.m_sSessionID = ValueEnforcer.notEmpty(string3, "SessionID");
    }

    @Nonnull
    @Nonempty
    public String getApplicationID() {
        return this.m_sApplicationID;
    }

    @Nonnull
    @Nonempty
    public String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    @Nonempty
    public String getSessionID() {
        return this.m_sSessionID;
    }

    @Nullable
    protected abstract DATATYPE scopedRun();

    @Override
    @Nullable
    public final DATATYPE call() {
        ScopeManager.onRequestBegin(this.m_sApplicationID, this.m_sRequestID, this.m_sSessionID);
        try {
            DATATYPE DATATYPE;
            DATATYPE DATATYPE2 = DATATYPE = this.scopedRun();
            return DATATYPE2;
        }
        finally {
            ScopeManager.onRequestEnd();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("applicationID", this.m_sApplicationID).append("requestID", this.m_sRequestID).append("sessionID", this.m_sSessionID).toString();
    }
}

