/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.math.MathHelper;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForSigned;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringHelper {
    public static final int STRING_NOT_FOUND = -1;
    private static final int[] s_aSizeTableInt = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] s_aSizeTableLong = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final StringHelper s_aInstance = new StringHelper();

    private StringHelper() {
    }

    public static boolean hasNoText(@Nullable CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean hasNoText(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isEmpty(@Nullable CharSequence charSequence) {
        return StringHelper.hasNoText(charSequence);
    }

    public static boolean isEmpty(@Nullable String string) {
        return StringHelper.hasNoText(string);
    }

    public static boolean hasNoTextAfterTrim(@Nullable String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isEmptyAfterTrim(@Nullable String string) {
        return StringHelper.hasNoTextAfterTrim(string);
    }

    public static boolean hasText(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasText(@Nullable String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence charSequence) {
        return StringHelper.hasText(charSequence);
    }

    public static boolean isNotEmpty(@Nullable String string) {
        return StringHelper.hasText(string);
    }

    public static boolean hasTextAfterTrim(@Nullable String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean isNotEmptyAfterTrim(@Nullable String string) {
        return StringHelper.hasTextAfterTrim(string);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Byte by, int n) {
        return by == null ? null : StringHelper.getLeadingZero((int)by.byteValue(), n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Integer n, int n2) {
        return n == null ? null : StringHelper.getLeadingZero(n.longValue(), n2);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Long l, int n) {
        return l == null ? null : StringHelper.getLeadingZero((long)l, n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Short s, int n) {
        return s == null ? null : StringHelper.getLeadingZero((int)s.shortValue(), n);
    }

    @Nonnull
    public static String getLeadingZero(int n, int n2) {
        boolean bl = n < 0;
        String string = Integer.toString(MathHelper.abs(n));
        if (string.length() >= n2) {
            return bl ? '-' + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n2);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(long l, int n) {
        boolean bl = l < 0L;
        String string = Long.toString(MathHelper.abs(l));
        if (string.length() >= n) {
            return bl ? '-' + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(@Nonnull String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n - n2; ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    public static char getHexChar(int n) {
        return Character.forDigit(n, 16);
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Input");
        ValueEnforcer.notNull(charset, "Charset");
        return StringHelper.getHexEncoded(CharsetManager.getAsBytes(string, charset));
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Input");
        return StringHelper.getHexEncoded(byArray, 0, byArray.length);
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] byArray, int n, int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            char c = StringHelper.getHexChar((by & 0xF0) >> 4);
            char c2 = StringHelper.getHexChar(by & 0xF);
            stringBuilder.append(c).append(c2);
        }
        return stringBuilder.toString();
    }

    @CheckForSigned
    public static int getHexValue(@Nonnegative char c) {
        return Character.digit(c, 16);
    }

    public static int getHexByte(@Nonnegative char c, @Nonnegative char c2) {
        int n = StringHelper.getHexValue(c);
        int n2 = StringHelper.getHexValue(c2);
        return n < 0 || n2 < 0 ? -1 : n << 4 | n2;
    }

    @Nonnull
    public static byte[] getHexDecoded(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Input");
        return StringHelper.getHexDecoded(string.toCharArray(), 0, string.length());
    }

    @Nonnull
    public static byte[] getHexDecoded(@Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "Input");
        return StringHelper.getHexDecoded(cArray, 0, cArray.length);
    }

    @Nonnull
    public static byte[] getHexDecoded(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        if (n2 % 2 > 0) {
            throw new IllegalArgumentException("Passed chars have no even length: " + n2);
        }
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            char c = cArray[n + i];
            char c2 = cArray[n + i + 1];
            int n4 = StringHelper.getHexByte(c, c2);
            if (n4 == -1) {
                throw new IllegalArgumentException("Failed to convert '" + c + "' or '" + c2 + "' to a hex value!");
            }
            byArray[n3++] = (byte)n4;
        }
        return byArray;
    }

    @Nonnull
    public static String getHexString(byte by) {
        return Integer.toString(by & 0xFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(byte by, int n) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(by), n);
    }

    @Nonnull
    public static String getHexStringLeadingZero2(byte by) {
        String string = StringHelper.getHexString(by);
        return string.length() >= 2 ? string : '0' + string;
    }

    @Nonnull
    public static String getHexString(int n) {
        return Integer.toString(n, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(int n, int n2) {
        if (n < 0) {
            return "-" + StringHelper.getLeadingZero(StringHelper.getHexString(-n), n2 - 1);
        }
        return StringHelper.getLeadingZero(StringHelper.getHexString(n), n2);
    }

    @Nonnull
    public static String getHexString(long l) {
        return Long.toString(l, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(long l, int n) {
        if (l < 0L) {
            return "-" + StringHelper.getLeadingZero(StringHelper.getHexString(-l), n - 1);
        }
        return StringHelper.getLeadingZero(StringHelper.getHexString(l), n);
    }

    @Nonnull
    public static String getHexString(short s) {
        return Integer.toString(s & 0xFFFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(short s, int n) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(s), n);
    }

    @Nonnegative
    public static int getLeadingWhitespaceCount(@Nullable String string) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingWhitespaceCount(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLeadingCharCount(@Nullable String string, char c) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingCharCount(@Nullable String string, char c) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    public static String getImploded(@Nullable Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable != null) {
            for (Object obj : iterable) {
                stringBuilder.append(obj);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getImploded(@Nonnull String string, @Nullable Iterable<?> iterable) {
        ValueEnforcer.notNull(string, "serparator");
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable != null) {
            int n = 0;
            for (Object obj : iterable) {
                if (n++ > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(obj);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getImploded(char c, @Nullable Iterable<?> iterable) {
        return StringHelper.getImploded(Character.toString(c), iterable);
    }

    @Nonnull
    public static String getImploded(@Nonnull String string, @Nonnull String string2, @Nullable Map<?, ?> map) {
        ValueEnforcer.notNull(string, "SepOuter");
        ValueEnforcer.notNull(string2, "SepInner");
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            int n = 0;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (n++ > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(entry.getKey()).append(string2).append(entry.getValue());
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getImploded(char c, char c2, @Nullable Map<?, ?> map) {
        return StringHelper.getImploded(Character.toString(c), Character.toString(c2), map);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return "";
        }
        return StringHelper.getImploded(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        if (ELEMENTTYPEArray != null) {
            ValueEnforcer.isArrayOfsLen(ELEMENTTYPEArray, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ELEMENTTYPEArray != null) {
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append(ELEMENTTYPEArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, ELEMENTTYPE ... ELEMENTTYPEArray) {
        ValueEnforcer.notNull(string, "Separator");
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return "";
        }
        return StringHelper.getImploded(string, ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char c, ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringHelper.getImploded(Character.toString(c), ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(string, "Separator");
        if (ELEMENTTYPEArray != null) {
            ValueEnforcer.isArrayOfsLen(ELEMENTTYPEArray, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (ELEMENTTYPEArray != null) {
            for (int i = n; i < n + n2; ++i) {
                ELEMENTTYPE ELEMENTTYPE = ELEMENTTYPEArray[i];
                if (i > n) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(ELEMENTTYPE);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.getImploded(Character.toString(c), ELEMENTTYPEArray, n, n2);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable Iterable<String> iterable) {
        ValueEnforcer.notNull(string, "Separator");
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable != null) {
            int n = 0;
            for (String string2 : iterable) {
                if (!StringHelper.hasText(string2)) continue;
                if (n++ > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable Iterable<String> iterable) {
        return StringHelper.getImplodedNonEmpty(Character.toString(c), iterable);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, String ... stringArray) {
        ValueEnforcer.notNull(string, "Separator");
        if (ArrayHelper.isEmpty(stringArray)) {
            return "";
        }
        return StringHelper.getImplodedNonEmpty(string, stringArray, 0, stringArray.length);
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, String ... stringArray) {
        return StringHelper.getImplodedNonEmpty(Character.toString(c), stringArray);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(string, "Separator");
        if (stringArray != null) {
            ValueEnforcer.isArrayOfsLen(stringArray, n, n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null) {
            int n3 = 0;
            for (int i = n; i < n + n2; ++i) {
                String string2 = stringArray[i];
                if (!StringHelper.hasText(string2)) continue;
                if (n3++ > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.getImplodedNonEmpty(Character.toString(c), stringArray, n, n2);
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string, @CheckForSigned int n) {
        int n2;
        if (n == 1) {
            return new String[]{string};
        }
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        int n3 = 1 + StringHelper.getCharCount(string, c);
        if (n3 == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n < 1 ? n3 : Math.min(n3, n)];
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(c, n4)) >= 0) {
            stringArray[n5++] = string.substring(n4, n2);
            n4 = n2 + 1;
            if (n <= 0 || n5 != n - 1) continue;
        }
        stringArray[n5++] = string.substring(n4);
        if (n5 != stringArray.length) {
            throw new IllegalStateException("Added " + n5 + " but expected " + stringArray.length);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string) {
        return StringHelper.getExplodedArray(c, string, -1);
    }

    @Nonnull
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(char c, @Nullable String string, int n, @Nonnull COLLTYPE COLLTYPE) {
        ValueEnforcer.notNull(COLLTYPE, "Collection");
        if (n == 1) {
            COLLTYPE.add((String)string);
        } else if (StringHelper.hasText(string)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string.indexOf(c, n3)) >= 0) {
                COLLTYPE.add((String)string.substring(n3, n2));
                n3 = n2 + 1;
                if (n <= 0 || ++n4 != n - 1) continue;
            }
            COLLTYPE.add((String)string.substring(n3));
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char c, @Nullable String string) {
        return StringHelper.getExploded(c, string, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char c, @Nullable String string, int n) {
        return StringHelper.getExploded(c, string, n, n >= 1 ? new ArrayList(n) : new ArrayList());
    }

    @Nonnull
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(@Nonnull String string, @Nullable String string2, int n, @Nonnull COLLTYPE COLLTYPE) {
        ValueEnforcer.notNull(string, "Separator");
        ValueEnforcer.notNull(COLLTYPE, "Collection");
        if (n == 1) {
            COLLTYPE.add((String)string2);
        } else {
            if (string.length() == 1) {
                return StringHelper.getExploded(string.charAt(0), string2, n, COLLTYPE);
            }
            if (StringHelper.hasText(string2)) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                while ((n2 = string2.indexOf(string, n3)) >= 0) {
                    COLLTYPE.add((String)string2.substring(n3, n2));
                    n3 = n2 + string.length();
                    if (n <= 0 || ++n4 != n - 1) continue;
                }
                COLLTYPE.add((String)string2.substring(n3));
            }
        }
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String string, @Nullable String string2, int n) {
        return StringHelper.getExploded(string, string2, n, n >= 1 ? new ArrayList(n) : new ArrayList());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getExplodedToSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new HashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getExplodedToOrderedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new LinkedHashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static SortedSet<String> getExplodedToSortedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new TreeSet());
    }

    @Nonnull
    public static String getRepeated(char c, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Repeats");
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return Character.toString(c);
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    @Nonnull
    public static String getRepeated(@Nonnull String string, @Nonnegative int n) {
        ValueEnforcer.notNull(string, "Element");
        ValueEnforcer.isGE0(n, "Repeats");
        int n2 = string.length();
        if ((long)n2 * (long)n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Resulting string exceeds the maximum integer length");
        }
        if (n2 == 0 || n == 0) {
            return "";
        }
        if (n == 1) {
            return string;
        }
        if (n2 == 1) {
            return StringHelper.getRepeated(string.charAt(0), n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2) {
        if (string == null) {
            return string2 == null ? "" : string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
            if (StringHelper.hasText(string2) && StringHelper.hasText(string3)) {
                stringBuilder.append(string2);
            }
        }
        if (StringHelper.hasText(string3)) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, char c, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
            if (StringHelper.hasText(string2)) {
                stringBuilder.append(c);
            }
        }
        if (StringHelper.hasText(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && charSequence.charAt(0) == c;
    }

    public static boolean startsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        if (StringHelper.hasText(charSequence) && cArray != null) {
            char c = charSequence.charAt(0);
            for (char c2 : cArray) {
                if (c != c2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && Character.toLowerCase(charSequence.charAt(0)) == Character.toLowerCase(c);
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n = charSequence2.length();
        return charSequence.length() >= n && charSequence.subSequence(0, n).equals(charSequence2);
    }

    public static boolean startsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        return string.length() >= n && string.substring(0, n).equalsIgnoreCase(string2);
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && StringHelper.getLastChar(charSequence) == c;
    }

    public static boolean endsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        if (StringHelper.hasText(charSequence) && cArray != null) {
            char c = StringHelper.getLastChar(charSequence);
            for (char c2 : cArray) {
                if (c != c2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        int n;
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n2 = charSequence.length();
        return n2 >= (n = charSequence2.length()) && charSequence.subSequence(n2 - n, n2).equals(charSequence2);
    }

    public static boolean endsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && Character.toLowerCase(StringHelper.getLastChar(charSequence)) == Character.toLowerCase(c);
    }

    public static boolean endsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        int n;
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = string.length();
        return n2 >= (n = string2.length()) && string.substring(n2 - n, n2).equalsIgnoreCase(string2);
    }

    public static int getIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.indexOf(string2) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.indexOf(string2, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.lastIndexOf(string2) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.lastIndexOf(string2, n) : -1;
    }

    public static int getIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.indexOf(c) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.indexOf(c, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.lastIndexOf(c) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.lastIndexOf(c, n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c), n) : -1;
    }

    public static boolean contains(@Nullable String string, @Nullable String string2) {
        return StringHelper.getIndexOf(string, string2) != -1;
    }

    public static boolean contains(@Nullable String string, char c) {
        return StringHelper.getIndexOf(string, c) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, string2, locale) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, c, locale) != -1;
    }

    public static boolean containsAny(@Nullable char[] cArray, @Nonnull char[] cArray2) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        if (cArray != null) {
            for (char c : cArray) {
                if (!ArrayHelper.contains(cArray2, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String string, @Nonnull char[] cArray) {
        return string != null && StringHelper.containsAny(string.toCharArray(), cArray);
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String string, @Nullable String string2) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        int n3 = StringHelper.getLength(string2);
        if (n3 > 0 && n2 >= n3) {
            int n4;
            int n5 = 0;
            do {
                if ((n4 = StringHelper.getIndexOf(string, n5, string2)) == -1) continue;
                ++n;
                n5 = n4 + n3;
            } while (n4 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null ? StringHelper.getOccurrenceCount(string.toLowerCase(locale), string2.toLowerCase(locale)) : 0;
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String string, char c) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        if (n2 >= 1) {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = StringHelper.getIndexOf(string, n4, c)) == -1) continue;
                ++n;
                n4 = n3 + 1;
            } while (n3 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null ? StringHelper.getOccurrenceCount(string.toLowerCase(locale), Character.toLowerCase(c)) : 0;
    }

    @Nullable
    @CheckReturnValue
    public static String trimLeadingWhitespaces(@Nullable String string) {
        int n = StringHelper.getLeadingWhitespaceCount(string);
        return n == 0 ? string : string.substring(n, string.length());
    }

    @Nullable
    @CheckReturnValue
    public static String trimTrailingWhitespaces(@Nullable String string) {
        int n = StringHelper.getTrailingWhitespaceCount(string);
        return n == 0 ? string : string.substring(0, string.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, @Nullable String string2) {
        return StringHelper.startsWith((CharSequence)string, string2) ? string.substring(string2.length(), string.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.endsWith((CharSequence)string, string2) ? string.substring(0, string.length() - string2.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.trimStartAndEnd(string, string2, string2);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.trimStart(string, string2);
        return StringHelper.trimEnd(string4, string3);
    }

    @Nullable
    @CheckReturnValue
    public static String trim(@Nullable String string) {
        return StringHelper.hasNoText(string) ? string : string.trim();
    }

    public static char getFirstChar(@Nullable CharSequence charSequence) {
        return StringHelper.hasText(charSequence) ? charSequence.charAt(0) : (char)'\u0000';
    }

    public static char getFirstChar(@Nullable char[] cArray) {
        return ArrayHelper.getFirst(cArray, '\u0000');
    }

    public static char getLastChar(@Nullable CharSequence charSequence) {
        int n = StringHelper.getLength(charSequence);
        return n > 0 ? charSequence.charAt(n - 1) : (char)'\u0000';
    }

    public static char getLastChar(@Nullable char[] cArray) {
        return ArrayHelper.getLast(cArray, '\u0000');
    }

    @Nonnegative
    public static int getCharCount(@Nullable String string, char c) {
        return string == null ? 0 : StringHelper.getCharCount(string.toCharArray(), c);
    }

    @Nonnegative
    public static int getCharCount(@Nullable char[] cArray, char c) {
        int n = 0;
        if (cArray != null) {
            for (char c2 : cArray) {
                if (c2 != c) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string) {
        return StringHelper.getLineCount(string, '\n');
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string, char c) {
        return 1 + StringHelper.getCharCount(string, c);
    }

    @Nonnegative
    public static int getCharacterCount(int n) {
        int n2 = n < 0 ? 2 : 1;
        int n3 = MathHelper.abs(n);
        int n4 = 0;
        while (n3 > s_aSizeTableInt[n4]) {
            ++n4;
        }
        return n2 + n4;
    }

    @Nonnegative
    public static int getCharacterCount(long l) {
        int n = l < 0L ? 2 : 1;
        long l2 = MathHelper.abs(l);
        int n2 = 0;
        while (l2 > s_aSizeTableLong[n2]) {
            ++n2;
        }
        return n + n2;
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n) {
        return StringHelper.getCutAfterLength(string, n, null);
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n, @Nullable String string2) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.isGE0(n, "MaxLength");
        if (string.length() <= n) {
            return string;
        }
        if (StringHelper.isEmpty(string2)) {
            return string.substring(0, n);
        }
        return string.substring(0, n) + string2;
    }

    public static String replaceAllSafe(@Nullable String string, @Nonnull String string2, @Nullable CharSequence charSequence) {
        return StringHelper.replaceAll(string, string2, StringHelper.getNotNull(charSequence, (CharSequence)""));
    }

    @Nullable
    public static String replaceAll(@Nullable String string, @Nonnull String string2, @Nonnull CharSequence charSequence) {
        int n;
        int n2;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(charSequence, "ReplacementText");
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n3 = string2.length();
        if (n3 == (n2 = charSequence.length())) {
            if (string2.equals(charSequence)) {
                return string;
            }
            if (n3 == 1) {
                return StringHelper.replaceAll(string, string2.charAt(0), charSequence.charAt(0));
            }
        }
        if ((n = string.indexOf(string2, 0)) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 >= n2 ? string.length() : string.length() * 2);
        int n4 = 0;
        do {
            stringBuilder.append(string, n4, n).append(charSequence);
            n4 = n += n3;
        } while ((n = string.indexOf(string2, n)) != -1);
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAll(@Nullable String string, char c, char c2) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        if (c == c2) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            stringBuilder.append(string, n2, n).append(c2);
            n2 = ++n;
        } while ((n = string.indexOf(c, n)) != -1);
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAllRepeatedly(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        String string4;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(string3, "ReplacementText");
        if (string3.contains(string2)) {
            throw new IllegalArgumentException("Loop detection: replacementText must not contain searchText");
        }
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string5 = string;
        while (!(string4 = string5).equals(string5 = StringHelper.replaceAll(string5, string2, string3))) {
        }
        return string5;
    }

    public static int getReplaceMultipleResultLength(@Nonnull char[] cArray, @Nonnull @Nonempty char[] cArray2, @Nonnull @Nonempty char[][] cArray3) {
        int n = 0;
        boolean bl = false;
        for (char c : cArray) {
            int n2 = 1;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                n2 = cArray3[i].length;
                bl = true;
                break;
            }
            n += n2;
        }
        return bl ? n : -1;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2) {
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        return StringHelper.replaceMultiple(string.toCharArray(), cArray, cArray2);
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        if (cArray2.length != cArray3.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        if (cArray == null || cArray.length == 0) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        if (cArray2.length == 0) {
            return cArray;
        }
        int n = StringHelper.getReplaceMultipleResultLength(cArray, cArray2, cArray3);
        if (n == -1) {
            return cArray;
        }
        char[] cArray4 = new char[n];
        int n2 = 0;
        for (char c : cArray) {
            boolean bl = false;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                char[] cArray5 = cArray3[i];
                int n3 = cArray5.length;
                System.arraycopy(cArray5, 0, cArray4, n2, n3);
                n2 += n3;
                bl = true;
                break;
            }
            if (bl) continue;
            cArray4[n2++] = c;
        }
        return cArray4;
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2, @Nonnull Writer writer) throws IOException {
        if (StringHelper.hasNoText(string)) {
            return 0;
        }
        return StringHelper.replaceMultipleTo(string.toCharArray(), cArray, cArray2, writer);
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3, @Nonnull Writer writer) throws IOException {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        if (cArray2.length != cArray3.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        ValueEnforcer.notNull(writer, "Target");
        if (cArray == null || cArray.length == 0) {
            return 0;
        }
        if (cArray2.length == 0) {
            writer.write(cArray);
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray2.length;
        for (char c : cArray) {
            for (int i = 0; i < n4; ++i) {
                if (c != cArray2[i]) continue;
                if (n < n2) {
                    writer.write(cArray, n, n2 - n);
                }
                n = n2 + 1;
                writer.write(cArray3[i]);
                ++n3;
                break;
            }
            ++n2;
        }
        if (n < n2) {
            writer.write(cArray, n, n2 - n);
        }
        return n3;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, char c) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        char[] cArray2 = string.toCharArray();
        if (cArray.length == 0) {
            return cArray2;
        }
        char[] cArray3 = new char[cArray2.length];
        int n = 0;
        for (char c2 : cArray2) {
            cArray3[n] = ArrayHelper.contains(cArray, c2) ? c : c2;
            ++n;
        }
        return cArray3;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable Map<String, String> map) {
        if (StringHelper.hasNoText(string) || map == null || map.isEmpty()) {
            return string;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = StringHelper.replaceAll(string2, entry.getKey(), entry.getValue());
        }
        return string2;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable String[] stringArray, @Nullable String[] stringArray2) {
        int n;
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = n = stringArray2 == null ? 0 : stringArray2.length;
        if (n2 != n) {
            throw new IllegalArgumentException("Array length mismatch!");
        }
        if (n2 == 0) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < n2; ++i) {
            string2 = StringHelper.replaceAll(string2, stringArray[i], stringArray2[i]);
        }
        return string2;
    }

    @Nullable
    public static String removeAll(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(cArray, 0, n);
        for (int i = n; i < n2; ++i) {
            char c2 = cArray[i];
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Nonnegative
    public static int getLength(@Nullable CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    @Nonnull
    public static String getNotNull(@Nullable String string) {
        return StringHelper.getNotNull(string, "");
    }

    @Nullable
    public static String getNotNull(@Nullable String string, String string2) {
        return string == null ? string2 : string;
    }

    @Nonnull
    public static CharSequence getNotNull(@Nullable CharSequence charSequence) {
        return StringHelper.getNotNull(charSequence, (CharSequence)"");
    }

    @Nullable
    public static CharSequence getNotNull(@Nullable CharSequence charSequence, CharSequence charSequence2) {
        return charSequence == null ? charSequence2 : charSequence;
    }

    @Nonnull
    public static String getToString(@Nullable Object object) {
        return StringHelper.getToString(object, "");
    }

    @Nullable
    public static String getToString(@Nullable Object object, @Nullable String string) {
        return object == null ? string : object.toString();
    }

    @Nonnull
    public static String getWithoutLeadingChar(@Nullable String string) {
        return StringHelper.getWithoutLeadingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutLeadingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(n);
    }

    @Nonnull
    public static String getWithoutTrailingChar(@Nullable String string) {
        return StringHelper.getWithoutTrailingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutTrailingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        int n2 = StringHelper.getLength(string);
        return n2 <= n ? "" : string.substring(0, n2 - n);
    }

    @Nonnull
    public static String getWithoutAnySpaces(@Nullable String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.trim().toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        for (char c : cArray) {
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        return n == -1 ? null : string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, false);
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return "";
        }
        int n = StringHelper.getIndexOf(string, string2);
        return n == -1 ? null : string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        return n == -1 ? null : string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return "";
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        return n == -1 ? null : string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        return n == -1 ? null : string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        return n == -1 ? null : string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        return n == -1 ? null : string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        return n == -1 ? null : string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, false);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, char c) {
        int n = StringHelper.getIndexOf(string, c);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, char c) {
        int n = StringHelper.getLastIndexOf(string, c);
        return n == -1 ? string : string.substring(n + 1);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        return n == -1 ? string : string.substring(n + StringHelper.getLength(string2));
    }

    @Nullable
    public static String getReverse(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length <= 1) {
            return string;
        }
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        int n2 = 0;
        while (n != -1) {
            cArray2[n2] = cArray[n];
            --n;
            ++n2;
        }
        return new String(cArray2);
    }

    @Nonnull
    public static String removeMultiple(@Nullable String string, @Nonnull char[] cArray) {
        char[] cArray2;
        ValueEnforcer.notNull(cArray, "RemoveChars");
        if (StringHelper.hasNoText(string)) {
            return "";
        }
        if (cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block0: for (char c : cArray2 = string.toCharArray()) {
            for (char c2 : cArray) {
                if (c == c2) continue block0;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

