/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StringScanner {
    private final String m_sInput;
    private final int m_nMaxIndex;
    private int m_nCurIndex = 0;

    public StringScanner(@Nonnull String string) {
        this.m_sInput = ValueEnforcer.notNull(string, "Input");
        this.m_nMaxIndex = string.length();
    }

    @Nonnegative
    public int getCurrentIndex() {
        return this.m_nCurIndex;
    }

    @Nonnegative
    public int getRemainingChars() {
        return this.m_nMaxIndex - this.m_nCurIndex;
    }

    @Nonnull
    public StringScanner skipWhitespaces() {
        while (this.m_nCurIndex < this.m_nMaxIndex && Character.isWhitespace(this.getCurrentChar())) {
            ++this.m_nCurIndex;
        }
        return this;
    }

    @Nonnull
    public StringScanner skipbackWhitespaces() {
        while (this.m_nCurIndex > 0 && this.m_nCurIndex < this.m_nMaxIndex && Character.isWhitespace(this.getCurrentChar())) {
            --this.m_nCurIndex;
        }
        return this;
    }

    @Nonnull
    public StringScanner skip(int n) {
        this.m_nCurIndex = Math.min(Math.max(this.m_nCurIndex + n, 0), this.m_nMaxIndex);
        return this;
    }

    public int findFirstIndex(char ... cArray) {
        int n = -1;
        for (char c : cArray) {
            int n2 = this.m_sInput.indexOf(c, this.m_nCurIndex);
            if (n2 == -1 || n != -1 && n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public char getCharAtIndex(int n) {
        try {
            return this.m_sInput.charAt(n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IllegalArgumentException("At end of string: position " + n + " of " + this.m_nMaxIndex);
        }
    }

    public char getCurrentChar() {
        return this.getCharAtIndex(this.m_nCurIndex);
    }

    public boolean isCurrentChar(char c) {
        return this.getCurrentChar() == c;
    }

    @Nonnull
    public StringScanner setIndex(@Nonnegative int n) {
        ValueEnforcer.isBetweenInclusive(n, "Index", 0, this.m_nMaxIndex);
        this.m_nCurIndex = n;
        return this;
    }

    @Nonnull
    public String getRest() {
        String string = this.m_sInput.substring(this.m_nCurIndex);
        this.m_nCurIndex = this.m_nMaxIndex;
        return string;
    }

    @Nonnull
    public String getUntilIndex(int n) {
        String string = this.m_sInput.substring(this.m_nCurIndex, n);
        this.setIndex(n);
        return string;
    }

    @Nonnull
    public String getUntilWhiteSpace() {
        int n = this.m_nCurIndex;
        while (this.m_nCurIndex < this.m_nMaxIndex && !Character.isWhitespace(this.getCurrentChar())) {
            ++this.m_nCurIndex;
        }
        return this.m_sInput.substring(n, this.m_nCurIndex);
    }

    @Nonnull
    public String getUntil(char c) {
        int n = this.m_nCurIndex;
        while (this.m_nCurIndex < this.m_nMaxIndex && this.getCurrentChar() != c) {
            ++this.m_nCurIndex;
        }
        return this.m_sInput.substring(n, this.m_nCurIndex);
    }

    @Nonnull
    public String getUntilBalanced(int n, char c, char c2) {
        int n2 = this.m_nCurIndex;
        int n3 = n;
        while (this.m_nCurIndex < this.m_nMaxIndex && n3 > 0) {
            char c3 = this.getCurrentChar();
            if (c3 == c) {
                ++n3;
            } else if (c3 == c2) {
                --n3;
            }
            ++this.m_nCurIndex;
        }
        if (this.m_nCurIndex == n2) {
            return "";
        }
        return this.m_sInput.substring(n2, this.m_nCurIndex - 1);
    }

    public String toString() {
        return new ToStringGenerator(this).append("input", this.m_sInput).append("maxIndex", this.m_nMaxIndex).append("curIndex", this.m_nCurIndex).toString();
    }
}

