/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.impl;

import com.helger.commons.annotations.IsSPIImplementation;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class CharsetTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Charset.class, String.class, (ITypeConverter)new TypeConverterCharsetString());
        iTypeConverterRegistry.registerTypeConverter(String.class, Charset.class, (ITypeConverter)new TypeConverterStringCharset());
    }

    private static final class TypeConverterCharsetString
    implements ITypeConverter {
        private TypeConverterCharsetString() {
        }

        @Override
        @Nonnull
        public String convert(@Nonnull Object object) {
            return ((Charset)object).name();
        }
    }

    private static final class TypeConverterStringCharset
    implements ITypeConverter {
        private TypeConverterStringCharset() {
        }

        @Override
        public Charset convert(@Nonnull Object object) {
            return CharsetManager.getCharsetFromName((String)object);
        }
    }
}

