/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.lang.ServiceLoaderUtils;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.IURLProtocolRegistrarSPI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLProtocolRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLProtocolRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final ReentrantReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Map<String, IURLProtocol> m_aProtocols = new HashMap<String, IURLProtocol>();

    private URLProtocolRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static URLProtocolRegistry getInstance() {
        s_bDefaultInstantiated = true;
        return SingletonHolder.s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aProtocols.clear();
            for (EURLProtocol eURLProtocol : EURLProtocol.values()) {
                this.m_aProtocols.put(eURLProtocol.getProtocol(), eURLProtocol);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        for (IURLProtocolRegistrarSPI iURLProtocolRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(IURLProtocolRegistrarSPI.class)) {
            Set<? extends IURLProtocol> set = iURLProtocolRegistrarSPI.getAllProtocols();
            if (set == null) continue;
            for (IURLProtocol iURLProtocol : set) {
                this.registerProtocol(iURLProtocol);
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug(this.getRegisteredProtocolCount() + " URL protocols registered");
        }
    }

    public void registerProtocol(@Nonnull IURLProtocol iURLProtocol) {
        ValueEnforcer.notNull(iURLProtocol, "Protocol");
        this.m_aRWLock.writeLock().lock();
        try {
            String string = iURLProtocol.getProtocol();
            if (this.m_aProtocols.containsKey(string)) {
                throw new IllegalArgumentException("Another handler for protocol '" + string + "' is already registered!");
            }
            this.m_aProtocols.put(string, iURLProtocol);
            s_aLogger.info("Registered new custom URL protocol: " + iURLProtocol);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Collection<IURLProtocol> getAllProtocols() {
        this.m_aRWLock.readLock().lock();
        try {
            List<IURLProtocol> list = CollectionHelper.newList(this.m_aProtocols.values());
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nonnegative
    public int getRegisteredProtocolCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aProtocols.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IURLProtocol getProtocol(@Nullable String string) {
        if (string != null) {
            this.m_aRWLock.readLock().lock();
            try {
                for (IURLProtocol iURLProtocol : this.m_aProtocols.values()) {
                    if (!iURLProtocol.isUsedInURL(string)) continue;
                    IURLProtocol iURLProtocol2 = iURLProtocol;
                    return iURLProtocol2;
                }
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
        }
        return null;
    }

    @Nullable
    public IURLProtocol getProtocol(@Nullable IURLData iURLData) {
        return iURLData == null ? null : this.getProtocol(iURLData.getPath());
    }

    public boolean hasKnownProtocol(@Nullable String string) {
        return this.getProtocol(string) != null;
    }

    public boolean hasKnownProtocol(@Nullable IURLData iURLData) {
        return this.getProtocol(iURLData) != null;
    }

    @Nullable
    public String getWithoutProtocol(@Nullable String string) {
        IURLProtocol iURLProtocol = this.getProtocol(string);
        return iURLProtocol == null ? string : string.substring(iURLProtocol.getProtocol().length());
    }

    private static final class SingletonHolder {
        static final URLProtocolRegistry s_aInstance = new URLProtocolRegistry();

        private SingletonHolder() {
        }
    }
}

