/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.AdapterRunnableToCallable;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.stats.IStatisticsHandlerTimer;
import com.helger.commons.stats.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainRunner {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MainRunner.class);
    private static final IStatisticsHandlerTimer s_aTimerHdl = StatisticsManager.getTimerHandler(MainRunner.class);
    private static final MainRunner s_aInstance = new MainRunner();

    private MainRunner() {
    }

    public static void run(@Nonnull IThrowingRunnable iThrowingRunnable) {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        StopWatch stopWatch = new StopWatch(true);
        try {
            iThrowingRunnable.run();
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error running application", throwable);
        }
        finally {
            s_aTimerHdl.addTime(stopWatch.stopAndGetMillis());
        }
    }

    public static void run(@Nonnull Runnable runnable) {
        MainRunner.run(AdapterRunnableToCallable.createAdapter(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <DATATYPE> DATATYPE run(@Nonnull Callable<DATATYPE> callable) {
        ValueEnforcer.notNull(callable, "Callable");
        StopWatch stopWatch = new StopWatch(true);
        try {
            DATATYPE DATATYPE = callable.call();
            return DATATYPE;
        }
        catch (Throwable throwable) {
            s_aLogger.error("Error running application", throwable);
            DATATYPE DATATYPE = null;
            return DATATYPE;
        }
        finally {
            s_aTimerHdl.addTime(stopWatch.stopAndGetMillis());
        }
    }
}

