/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.filter.ISerializableFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithTagName
implements ISerializableFilter<Element> {
    private final String m_sTagName;

    public FilterElementWithTagName(@Nonnull @Nonempty String string) {
        this.m_sTagName = ValueEnforcer.notNull(string, "TagName");
    }

    @Nonnull
    @Nonempty
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    public boolean matchesFilter(@Nullable Element element) {
        return element != null && element.getNamespaceURI() == null && element.getTagName().equals(this.m_sTagName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FilterElementWithTagName filterElementWithTagName = (FilterElementWithTagName)object;
        return this.m_sTagName.equals(filterElementWithTagName.m_sTagName);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sTagName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("tagName", this.m_sTagName).toString();
    }
}

