/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons;

import com.helger.commons.annotations.DevelopersNote;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.priviledged.AccessControllerHelper;
import com.helger.commons.priviledged.PrivilegedActionSystemClearProperty;
import com.helger.commons.priviledged.PrivilegedActionSystemGetProperties;
import com.helger.commons.priviledged.PrivilegedActionSystemGetProperty;
import com.helger.commons.priviledged.PrivilegedActionSystemSetProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SystemProperties {
    public static final String SYSTEM_PROPERTY_FILE_SEPARATOR = "file.separator";
    public static final String SYSTEM_PROPERTY_JAVA_CLASS_PATH = "java.class.path";
    public static final String SYSTEM_PROPERTY_JAVA_CLASS_VERSION = "java.class.version";
    public static final String SYSTEM_PROPERTY_JAVA_LIBRARY_PATH = "java.library.path";
    public static final String SYSTEM_PROPERTY_JAVA_HOME = "java.home";
    public static final String SYSTEM_PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_URL = "java.specification.url";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String SYSTEM_PROPERTY_JAVA_VENDOR = "java.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VENDOR_URL = "java.vendor.url";
    public static final String SYSTEM_PROPERTY_JAVA_VERSION = "java.version";
    public static final String SYSTEM_PROPERTY_JAVA_VM_NAME = "java.vm.name";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_URL = "java.vm.specification.url";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String SYSTEM_PROPERTY_JAVA_VM_URL = "java.vm.url";
    public static final String SYSTEM_PROPERTY_JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String SYSTEM_PROPERTY_JAVA_VM_VERSION = "java.vm.version";
    public static final String SYSTEM_PROPERTY_LINE_SEPARATOR = "line.separator";
    public static final String SYSTEM_PROPERTY_OS_ARCH = "os.arch";
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    public static final String SYSTEM_PROPERTY_OS_VERSION = "os.version";
    public static final String SYSTEM_PROPERTY_PATH_SEPARATOR = "path.separator";
    public static final String SYSTEM_PROPERTY_USER_DIR = "user.dir";
    public static final String SYSTEM_PROPERTY_USER_HOME = "user.home";
    public static final String SYSTEM_PROPERTY_USER_NAME = "user.name";
    public static final String SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT = "jdx.xml.entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT = "jdx.xml.elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR = "jdx.xml.maxOccur";
    public static final String SYSTEM_PROPERTY_MAX_OCCUR = "maxOccur";
    public static final String SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT = "jdx.xml.totalEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT = "jdx.xml.maxGeneralEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT = "jdx.xml.maxParameterEntitySizeLimit";
    private static final Logger s_aLogger = LoggerFactory.getLogger(SystemProperties.class);
    private static final Set<String> s_aWarnedPropertyNames = Collections.synchronizedSet(new HashSet());
    private static final SystemProperties s_aInstance = new SystemProperties();

    private SystemProperties() {
    }

    @Nullable
    public static String getPropertyValueOrNull(@Nullable String string) {
        return string == null ? null : AccessControllerHelper.call(new PrivilegedActionSystemGetProperty(string));
    }

    @Nullable
    public static String getPropertyValue(@Nullable String string) {
        String string2 = null;
        if (string != null && (string2 = SystemProperties.getPropertyValueOrNull(string)) == null && s_aWarnedPropertyNames.add(string)) {
            s_aLogger.warn("System property '" + string + "' is not set!");
        }
        return string2;
    }

    public static void clearWarnedPropertyNames() {
        s_aWarnedPropertyNames.clear();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllWarnedPropertyNames() {
        return new HashSet<String>(s_aWarnedPropertyNames);
    }

    public static void setPropertyValue(@Nonnull String string, @Nullable String string2) {
        if (string2 == null) {
            SystemProperties.removePropertyValue(string);
        } else {
            AccessControllerHelper.run(new PrivilegedActionSystemSetProperty(string, string2));
        }
    }

    @Nullable
    public static String removePropertyValue(@Nonnull String string) {
        return AccessControllerHelper.call(new PrivilegedActionSystemClearProperty(string));
    }

    @Nullable
    public static String getJavaVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VERSION);
    }

    @Nullable
    public static String getJavaVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VENDOR);
    }

    @Nullable
    public static String getJavaVendorURL() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VENDOR_URL);
    }

    @Nullable
    public static String getJavaHome() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_HOME);
    }

    @Nullable
    public static String getJavaClassVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_CLASS_VERSION);
    }

    @Nullable
    public static String getJavaClassPath() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_CLASS_PATH);
    }

    @Nullable
    public static String getJavaLibraryPath() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH);
    }

    @Nullable
    public static String getOsName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_NAME);
    }

    @Nullable
    public static String getOsArch() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_ARCH);
    }

    @Nullable
    public static String getOsVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_OS_VERSION);
    }

    @Nullable
    public static String getFileSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_FILE_SEPARATOR);
    }

    @Nullable
    public static String getPathSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_PATH_SEPARATOR);
    }

    @Nullable
    public static String getLineSeparator() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_LINE_SEPARATOR);
    }

    @Nullable
    public static String getUserName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_NAME);
    }

    @Nullable
    public static String getUserHome() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_HOME);
    }

    @Nullable
    public static String getUserDir() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_USER_DIR);
    }

    @Nullable
    public static String getJavaVmName() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_NAME);
    }

    @Nullable
    public static String getJavaVmSpecificationVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VERSION);
    }

    @Nullable
    public static String getJavaVmSpecificationVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_VENDOR);
    }

    @Nullable
    public static String getJavaVmSpecificationUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_SPECIFICATION_URL);
    }

    @Nullable
    public static String getJavaVmVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_VERSION);
    }

    @Nullable
    public static String getJavaVmVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_VENDOR);
    }

    @Nullable
    public static String getJavaVmUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_VM_URL);
    }

    @Nullable
    public static String getJavaSpecificationVersion() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_VERSION);
    }

    @Nullable
    public static String getJavaSpecificationVendor() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_VENDOR);
    }

    @Nullable
    public static String getJavaSpecificationUrl() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_SPECIFICATION_URL);
    }

    @Nullable
    @DevelopersNote(value="This property is not part of the language but part of the Sun SDK")
    public static String getTmpDir() {
        return SystemProperties.getPropertyValue(SYSTEM_PROPERTY_JAVA_IO_TMPDIR);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllPropertyNames() {
        return new HashSet<String>(SystemProperties.getAllProperties().keySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getAllProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = AccessControllerHelper.call(new PrivilegedActionSystemGetProperties());
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                hashMap.put(string, (String)entry.getValue());
            }
        }
        return hashMap;
    }

    public static boolean containsPropertyName(String string) {
        return SystemProperties.getAllProperties().containsKey(string);
    }

    public static void setXMLEntityExpansionLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT, Integer.toString(n));
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT, Integer.toString(n));
    }

    public static int getXMLEntityExpansionLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
        }
        if (string == null) {
            return 64000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLElementAttributeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT, Integer.toString(n));
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT, Integer.toString(n));
    }

    public static int getXMLElementAttributeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
        }
        if (string == null) {
            return 10000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxOccur(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_MAX_OCCUR, Integer.toString(n));
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR, Integer.toString(n));
    }

    public static int getXMLMaxOccur() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_MAX_OCCUR);
        }
        if (string == null) {
            return 5000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLTotalEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT, Integer.toString(n));
    }

    public static int getXMLTotalEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 500000000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxGeneralEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT, Integer.toString(n));
    }

    public static int getXMLMaxGeneralEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxParameterEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT, Integer.toString(n));
    }

    public static int getXMLMaxParameterEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }
}

