/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.ICallback;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class CallbackList<CALLBACKTYPE extends ICallback>
implements ICloneable<CallbackList<CALLBACKTYPE>> {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<CALLBACKTYPE> m_aCallbacks = new ArrayList<CALLBACKTYPE>();

    public CallbackList() {
    }

    public CallbackList(@Nonnull CallbackList<CALLBACKTYPE> callbackList) {
        ValueEnforcer.notNull(callbackList, "Other");
        this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CallbackList<CALLBACKTYPE> addCallback(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aCallbacks.add(CALLBACKTYPE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange removeCallback(@Nullable CALLBACKTYPE CALLBACKTYPE) {
        if (CALLBACKTYPE == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aCallbacks.remove(CALLBACKTYPE));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange removeAllCallbacks() {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCallbacks.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aCallbacks.clear();
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<CALLBACKTYPE> getAllCallbacks() {
        this.m_aRWLock.readLock().lock();
        try {
            List<CALLBACKTYPE> list = CollectionHelper.newList(this.m_aCallbacks);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CALLBACKTYPE getCallbackAtIndex(@Nonnegative int n) {
        this.m_aRWLock.readLock().lock();
        try {
            ICallback iCallback = (ICallback)CollectionHelper.getSafe(this.m_aCallbacks, n);
            return (CALLBACKTYPE)iCallback;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getCallbackCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aCallbacks.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCallbacks() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = !this.m_aCallbacks.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public CallbackList<CALLBACKTYPE> getClone() {
        return new CallbackList<CALLBACKTYPE>(this);
    }

    public String toString() {
        return new ToStringGenerator(this).append("callbacks", this.m_aCallbacks).toString();
    }
}

