/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.attrs;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.collections.attrs.AbstractGenericReadonlyAttributeContainer;
import com.helger.commons.collections.attrs.IGenericReadonlyAttributeContainer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedGenericReadonlyAttributeContainer<KEYTYPE, VALUETYPE>
extends AbstractGenericReadonlyAttributeContainer<KEYTYPE, VALUETYPE> {
    private final Map<KEYTYPE, VALUETYPE> m_aAttrs = new HashMap<KEYTYPE, VALUETYPE>();

    public MapBasedGenericReadonlyAttributeContainer(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.m_aAttrs.put(KEYTYPE, VALUETYPE);
    }

    public MapBasedGenericReadonlyAttributeContainer(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        ValueEnforcer.notNull(map, "Map");
        this.m_aAttrs.putAll(map);
    }

    public MapBasedGenericReadonlyAttributeContainer(@Nonnull IGenericReadonlyAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iGenericReadonlyAttributeContainer) {
        ValueEnforcer.notNull(iGenericReadonlyAttributeContainer, "Container");
        this.m_aAttrs.putAll(iGenericReadonlyAttributeContainer.getAllAttributes());
    }

    @Override
    public boolean containsAttribute(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aAttrs.containsKey(KEYTYPE);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<KEYTYPE, VALUETYPE> getAllAttributes() {
        return CollectionHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nonnull
    @Deprecated
    public Enumeration<KEYTYPE> getAttributeNames() {
        return CollectionHelper.getEnumeration(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<KEYTYPE> getAllAttributeNames() {
        return CollectionHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllAttributeValues() {
        return CollectionHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aAttrs.get(KEYTYPE);
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedGenericReadonlyAttributeContainer mapBasedGenericReadonlyAttributeContainer = (MapBasedGenericReadonlyAttributeContainer)object;
        return this.m_aAttrs.equals(mapBasedGenericReadonlyAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aAttrs).toString();
    }
}

