/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CompareUtils;
import com.helger.commons.compare.ESortOrder;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPartComparator<DATATYPE, PARTTYPE>
extends AbstractComparator<DATATYPE> {
    private Comparator<? super PARTTYPE> m_aPartComparator;

    public AbstractPartComparator(@Nonnull Comparator<? super PARTTYPE> comparator) {
        this(ESortOrder.DEFAULT, null, comparator);
    }

    public AbstractPartComparator(@Nonnull ESortOrder eSortOrder, @Nonnull Comparator<? super PARTTYPE> comparator) {
        this(eSortOrder, null, comparator);
    }

    public AbstractPartComparator(@Nullable Comparator<? super DATATYPE> comparator, @Nonnull Comparator<? super PARTTYPE> comparator2) {
        this(ESortOrder.DEFAULT, comparator, comparator2);
    }

    public AbstractPartComparator(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator, @Nonnull Comparator<? super PARTTYPE> comparator2) {
        super(eSortOrder, comparator);
        this.m_aPartComparator = ValueEnforcer.notNull(comparator2, "PartComparator");
    }

    @Nonnull
    public final Comparator<? super PARTTYPE> getPartComparator() {
        return this.m_aPartComparator;
    }

    @Nullable
    protected abstract PARTTYPE getPart(DATATYPE var1);

    @Override
    protected final int mainCompare(DATATYPE DATATYPE, DATATYPE DATATYPE2) {
        PARTTYPE PARTTYPE = this.getPart(DATATYPE);
        PARTTYPE PARTTYPE2 = this.getPart(DATATYPE2);
        return CompareUtils.nullSafeCompare(PARTTYPE, PARTTYPE2, this.m_aPartComparator);
    }
}

