/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IResourceError;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.name.IHasDisplayText;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.impl.ConstantTextProvider;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceError
implements IResourceError {
    private final IResourceLocation m_aLocation;
    private final IErrorLevel m_aErrorLevel;
    private final IHasDisplayText m_aErrorText;
    private final Throwable m_aLinkedException;

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        this(iResourceLocation, iErrorLevel, string, null);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        this(iResourceLocation, iErrorLevel, new ConstantTextProvider(string), throwable);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull IHasDisplayText iHasDisplayText) {
        this(iResourceLocation, iErrorLevel, iHasDisplayText, null);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull IErrorLevel iErrorLevel, @Nonnull IHasDisplayText iHasDisplayText, @Nullable Throwable throwable) {
        this.m_aLocation = ValueEnforcer.notNull(iResourceLocation, "Location");
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        this.m_aErrorText = ValueEnforcer.notNull(iHasDisplayText, "ErrorText");
        this.m_aLinkedException = throwable;
    }

    @Override
    @Nonnull
    public final IResourceLocation getLocation() {
        return this.m_aLocation;
    }

    @Override
    @Nonnull
    public final IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aErrorText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public final Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public String getAsString(@Nonnull Locale locale) {
        String string = "[" + (String)this.m_aErrorLevel.getID() + "] ";
        String string2 = this.m_aLocation.getAsString();
        if (StringHelper.hasText(string2)) {
            string = string + string2 + ": ";
        }
        string = string + this.getDisplayText(locale);
        if (this.m_aLinkedException != null) {
            string = string + " (" + this.m_aLinkedException.getMessage() + ")";
        }
        return string;
    }

    @Override
    public boolean isSuccess() {
        return this.m_aErrorLevel.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_aErrorLevel.isFailure();
    }

    @Override
    public boolean isError() {
        return this.m_aErrorLevel.isError();
    }

    @Override
    public boolean isNoError() {
        return this.m_aErrorLevel.isNoError();
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_aErrorLevel.isEqualSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isLessSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_aErrorLevel.isLessSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_aErrorLevel.isLessOrEqualSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_aErrorLevel.isMoreSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_aErrorLevel.isMoreOrEqualSevereThan(iResourceError.getErrorLevel());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceError resourceError = (ResourceError)object;
        return this.m_aLocation.equals(resourceError.m_aLocation) && this.m_aErrorLevel.equals(resourceError.m_aErrorLevel) && this.m_aErrorText.equals(resourceError.m_aErrorText);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aLocation).append(this.m_aErrorLevel).append(this.m_aErrorText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("location", this.m_aLocation).append("errorLevel", this.m_aErrorLevel).append("errorText", this.m_aErrorText).appendIfNotNull("linkedException", this.m_aLinkedException).toString();
    }
}

