/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SimpleErrorLevel
implements IErrorLevel {
    private final String m_sID;
    private final int m_nNumericLevel;

    public SimpleErrorLevel(@Nonnull @Nonempty String string, @Nonnegative int n) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_nNumericLevel = n;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isSuccess() {
        return this.isEqualSevereThan(EErrorLevel.SUCCESS);
    }

    @Override
    public boolean isFailure() {
        return !this.isSuccess();
    }

    @Override
    public boolean isError() {
        return this.isMoreOrEqualSevereThan(EErrorLevel.ERROR);
    }

    @Override
    public boolean isNoError() {
        return this.isLessSevereThan(EErrorLevel.ERROR);
    }

    @Override
    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() == iErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() < iErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() <= iErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() > iErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull IErrorLevel iErrorLevel) {
        return this.getNumericLevel() >= iErrorLevel.getNumericLevel();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleErrorLevel simpleErrorLevel = (SimpleErrorLevel)object;
        return this.m_sID.equals(simpleErrorLevel.m_sID) && this.m_nNumericLevel == simpleErrorLevel.m_nNumericLevel;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_nNumericLevel).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("numericLevel", this.m_nNumericLevel).toString();
    }
}

