/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.exceptions;

import com.helger.commons.exceptions.ILoggedException;
import com.helger.commons.exceptions.LoggedRuntimeException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedException
extends Exception
implements ILoggedException {
    public static final boolean DEFAULT_DO_LOG = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger((String)"ROOT");
    private static final String MSG_TEXT = "Exception created.";

    public LoggedException() {
        this(true);
    }

    public LoggedException(boolean bl) {
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable String string) {
        this(true, string);
    }

    public LoggedException(boolean bl, @Nullable String string) {
        super(string);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable Throwable throwable) {
        this(true, throwable);
    }

    public LoggedException(boolean bl, @Nullable Throwable throwable) {
        super(throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    public LoggedException(@Nullable String string, @Nullable Throwable throwable) {
        this(true, string, throwable);
    }

    public LoggedException(boolean bl, @Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        if (bl) {
            s_aLogger.error(MSG_TEXT, (Throwable)this);
        }
    }

    @Nonnull
    public static Exception newException(@Nullable Throwable throwable) {
        if (throwable instanceof LoggedException) {
            return (LoggedException)throwable;
        }
        if (throwable instanceof LoggedRuntimeException) {
            return new Exception(throwable);
        }
        return new LoggedException(throwable);
    }

    @Nonnull
    public static Exception newException(@Nullable String string, @Nullable Throwable throwable) {
        if (throwable instanceof LoggedException) {
            return (LoggedException)throwable;
        }
        if (throwable instanceof LoggedRuntimeException) {
            return new Exception(string, throwable);
        }
        return new LoggedException(string, throwable);
    }
}

