/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.format.impl;

import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.format.IFormatter;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractStringFormatter
implements IFormatter {
    private final IFormatter m_aPrevFormatter;

    public AbstractStringFormatter() {
        this(null);
    }

    public AbstractStringFormatter(@Nullable IFormatter iFormatter) {
        this.m_aPrevFormatter = iFormatter;
    }

    @Nullable
    public final IFormatter getPreviousFormatter() {
        return this.m_aPrevFormatter;
    }

    @Nonnull
    @OverrideOnDemand
    protected String getValueAsString(@Nullable Object object) {
        String string = TypeConverter.convertIfNecessary(object, String.class);
        return string != null ? string : "";
    }

    @Nullable
    protected abstract String getFormattedValueAsString(@Nullable Object var1);

    @Override
    @Nullable
    public final String getFormattedValue(@Nullable Object object) {
        Object object2 = this.m_aPrevFormatter == null ? object : this.m_aPrevFormatter.getFormattedValue(object);
        return this.getFormattedValueAsString(object2);
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prevFormatter", this.m_aPrevFormatter).toString();
    }
}

