/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.idfactory.IIntIDFactory;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryIntIDFactory
implements IIntIDFactory {
    @Nonnegative
    public static final int DEFAULT_START_ID = 10000;
    @Nonnegative
    private final AtomicInteger m_aID;

    public MemoryIntIDFactory() {
        this(10000);
    }

    public MemoryIntIDFactory(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "StartID");
        this.m_aID = new AtomicInteger(n);
    }

    @Override
    @Nonnegative
    public int getNewID() {
        return this.m_aID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MemoryIntIDFactory memoryIntIDFactory = (MemoryIntIDFactory)object;
        return this.m_aID.get() == memoryIntIDFactory.m_aID.get();
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aID.get()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_aID).toString();
    }
}

