/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterEndsWith
extends AbstractFileFilter {
    private final String m_sSuffix;

    public FilenameFilterEndsWith(@Nonnull @Nonempty String string) {
        this.m_sSuffix = ValueEnforcer.notEmpty(string, "Suffix");
    }

    @Nonnull
    @Nonempty
    public String getSuffix() {
        return this.m_sSuffix;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return file != null && FilenameHelper.getSecureFilename(file.getName()).endsWith(this.m_sSuffix);
    }

    public String toString() {
        return new ToStringGenerator(this).append("suffix", this.m_sSuffix).toString();
    }
}

