/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IInputStreamAndReaderProvider;
import com.helger.commons.io.streams.ByteBufferInputStream;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ByteBufferInputStreamProvider
implements IInputStreamAndReaderProvider {
    private final ByteBuffer m_aBuffer;

    public ByteBufferInputStreamProvider(@Nonnull ByteBuffer byteBuffer) {
        this.m_aBuffer = ValueEnforcer.notNull(byteBuffer, "Buffer");
    }

    @Nonnull
    public ByteBuffer getByteBuffer() {
        return this.m_aBuffer;
    }

    @Override
    @Nonnull
    public final ByteBufferInputStream getInputStream() {
        return new ByteBufferInputStream(this.m_aBuffer);
    }

    @Override
    @Nonnull
    @Deprecated
    public final InputStreamReader getReader(@Nonnull String string) {
        return StreamUtils.createReader((InputStream)this.getInputStream(), string);
    }

    @Override
    @Nonnull
    public final InputStreamReader getReader(@Nonnull Charset charset) {
        return StreamUtils.createReader((InputStream)this.getInputStream(), charset);
    }

    public String toString() {
        return new ToStringGenerator(null).append("buffer", this.m_aBuffer).toString();
    }
}

