/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.ValueEnforcer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingByteArrayInputStream
extends InputStream
implements Serializable {
    protected byte[] m_aBuf;
    protected int m_nPos;
    protected int m_nMark;
    protected int m_nCount;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingByteArrayInputStream(@Nonnull byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingByteArrayInputStream(byte[] byArray, int n, int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_aBuf = byArray;
        this.m_nPos = n;
        this.m_nCount = Math.min(n + n2, byArray.length);
        this.m_nMark = n;
    }

    @Override
    public int read() {
        return this.m_nPos < this.m_nCount ? this.m_aBuf[this.m_nPos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        if (this.m_nPos >= this.m_nCount) {
            return -1;
        }
        int n4 = n3 = this.m_nPos + n2 > this.m_nCount ? this.m_nCount - this.m_nPos : n2;
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.m_aBuf, this.m_nPos, byArray, n, n3);
        this.m_nPos += n3;
        return n3;
    }

    @Override
    public long skip(long l) {
        long l2;
        long l3 = l2 = (long)this.m_nPos + l > (long)this.m_nCount ? (long)(this.m_nCount - this.m_nPos) : l;
        if (l2 <= 0L) {
            return 0L;
        }
        this.m_nPos = (int)((long)this.m_nPos + l2);
        return l2;
    }

    @Override
    public int available() {
        return this.m_nCount - this.m_nPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.m_nMark = this.m_nPos;
    }

    @Override
    public void reset() {
        this.m_nPos = this.m_nMark;
    }

    @Override
    public void close() {
    }

    @Nonnegative
    public int getPosition() {
        return this.m_nPos;
    }
}

