/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jaxb;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ELockType;
import com.helger.commons.annotations.IsLocked;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.commons.lang.GenericReflection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends AbstractNotifyingCache<Package, JAXBContext> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JAXBContextCache.class);
    private static boolean s_bDefaultInstantiated = false;

    private JAXBContextCache() {
        super(JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        s_bDefaultInstantiated = true;
        return SingletonHolder.s_aInstance;
    }

    @Override
    @Nullable
    @IsLocked(value=ELockType.WRITE)
    public JAXBContext getValueToCache(@Nullable Package package_) {
        if (package_ == null) {
            return null;
        }
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.info("Creating JAXB context for package " + package_.getName());
        }
        try {
            if (package_.getAnnotation(XmlSchema.class) == null && GenericReflection.getClassFromNameSafe(package_.getName() + ".ObjectFactory") == null) {
                s_aLogger.warn("The package " + package_.getName() + " does not seem to be JAXB generated!");
            }
            return JAXBContext.newInstance((String)package_.getName());
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for package " + package_.getName();
            s_aLogger.error(string);
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) == null) {
            if (GlobalDebug.isDebugMode()) {
                s_aLogger.info("Creating JAXB context for class " + clazz.getName());
            }
            try {
                return JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (JAXBException jAXBException) {
                String string = "Failed to create JAXB context for class " + clazz.getName();
                s_aLogger.error(string);
                throw new IllegalArgumentException(string, jAXBException);
            }
        }
        return (JAXBContext)this.getFromCache(package_);
    }

    private static final class SingletonHolder {
        static final JAXBContextCache s_aInstance = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

