/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ByteBufferUtils {
    private static final ByteBufferUtils s_aInstance = new ByteBufferUtils();

    private ByteBufferUtils() {
    }

    @Nonnegative
    private static int _doTransfer(@Nonnull ByteBuffer byteBuffer, @Nonnull ByteBuffer byteBuffer2) {
        int n = byteBuffer.remaining();
        int n2 = byteBuffer2.remaining();
        if (n2 >= n) {
            byteBuffer2.put(byteBuffer);
            return n;
        }
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.position();
        byteBuffer.limit(n4 + n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n3);
        return n2;
    }

    @Nonnegative
    public static int transfer(@Nonnull ByteBuffer byteBuffer, @Nonnull ByteBuffer byteBuffer2, boolean bl) {
        ValueEnforcer.notNull(byteBuffer, "SourceBuffer");
        ValueEnforcer.notNull(byteBuffer2, "DestinationBuffer");
        int n = 0;
        if (bl) {
            if (byteBuffer.position() > 0) {
                byteBuffer.flip();
                n = ByteBufferUtils._doTransfer(byteBuffer, byteBuffer2);
                if (byteBuffer.hasRemaining()) {
                    byteBuffer.compact();
                } else {
                    byteBuffer.clear();
                }
            }
        } else if (byteBuffer.hasRemaining()) {
            n = ByteBufferUtils._doTransfer(byteBuffer, byteBuffer2);
        }
        return n;
    }
}

