/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ELockType;
import com.helger.commons.annotations.IsLocked;
import com.helger.commons.annotations.ReturnsImmutableObject;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.cache.AbstractNotifyingCache;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.locale.ELocaleName;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LocaleUtils {
    private static final String LOCALE_ALL_STR = CGlobal.LOCALE_ALL.toString();
    private static final String LOCALE_INDEPENDENT_STR = CGlobal.LOCALE_INDEPENDENT.toString();
    private static final LocaleListCache s_aLocaleListCache = new LocaleListCache();
    private static final LocaleUtils s_aInstance = new LocaleUtils();

    private LocaleUtils() {
    }

    @Nonnull
    public static String getLocaleDisplayName(@Nullable Locale locale, @Nonnull Locale locale2) {
        ValueEnforcer.notNull(locale2, "ContentLocale");
        if (locale == null || locale.equals(CGlobal.LOCALE_INDEPENDENT)) {
            return ELocaleName.ID_LANGUAGE_INDEPENDENT.getDisplayText(locale2);
        }
        if (locale.equals(CGlobal.LOCALE_ALL)) {
            return ELocaleName.ID_LANGUAGE_ALL.getDisplayText(locale2);
        }
        return locale.getDisplayName(locale2);
    }

    @Nonnull
    public static String getLocaleNativeDisplayName(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "Locale");
        return LocaleUtils.getLocaleDisplayName(locale, locale);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<Locale, String> getAllLocaleDisplayNames(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "ContentLocale");
        HashMap<Locale, String> hashMap = new HashMap<Locale, String>();
        for (Locale locale2 : LocaleCache.getAllLocales()) {
            hashMap.put(locale2, LocaleUtils.getLocaleDisplayName(locale2, locale));
        }
        return hashMap;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Locale> getCalculatedLocaleListForResolving(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "Locale");
        return (List)s_aLocaleListCache.getFromCache(locale);
    }

    @Nonnull
    public static Locale getLocaleFromString(@Nullable String string) {
        String string2;
        String string3;
        String string4;
        if (StringHelper.hasNoText(string)) {
            return SystemHelper.getSystemLocale();
        }
        int n = string.indexOf(95);
        if (n < 0) {
            string4 = string;
            string3 = "";
            string2 = "";
        } else {
            int n2;
            string4 = string.substring(0, n);
            if ((n2 = string.indexOf(95, ++n)) < 0) {
                string3 = string.substring(n);
                string2 = "";
            } else {
                string3 = string.substring(n, n2);
                string2 = string.substring(n2 + 1);
            }
        }
        string4 = string4.length() == 2 ? string4.toLowerCase(Locale.US) : "";
        string3 = string3.length() == 2 ? string3.toUpperCase(Locale.US) : "";
        string2 = string2.length() > 0 && (string4.length() == 2 || string3.length() == 2) ? string2.toUpperCase(Locale.US) : "";
        return LocaleCache.getLocale(string4, string3, string2);
    }

    @Nullable
    public static Locale getLocaleToUseOrNull(@Nonnull Locale locale, @Nonnull Collection<Locale> collection) {
        return LocaleUtils.getLocaleToUseOrFallback(locale, collection, null);
    }

    @Nullable
    public static Locale getLocaleToUseOrFallback(@Nonnull Locale locale, @Nonnull Collection<Locale> collection, @Nullable Locale locale2) {
        ValueEnforcer.notNull(locale, "RequestLocale");
        ValueEnforcer.notNull(collection, "AvailableLocales");
        if (collection.contains(locale)) {
            return locale;
        }
        for (Locale object : LocaleUtils.getCalculatedLocaleListForResolving(locale)) {
            if (!collection.contains(object)) continue;
            return object;
        }
        String string = locale.getLanguage();
        if (string != null) {
            for (Locale locale3 : collection) {
                if (!string.equals(locale3.getLanguage())) continue;
                return locale3;
            }
        }
        if (collection.contains(CGlobal.LOCALE_ALL)) {
            return CGlobal.LOCALE_ALL;
        }
        if (collection.contains(CGlobal.LOCALE_INDEPENDENT)) {
            return CGlobal.LOCALE_INDEPENDENT;
        }
        return locale2;
    }

    public static boolean isSpecialLocale(@Nullable Locale locale) {
        return CGlobal.LOCALE_ALL.equals(locale) || CGlobal.LOCALE_INDEPENDENT.equals(locale);
    }

    public static boolean isSpecialLocaleCode(@Nullable String string) {
        return LOCALE_ALL_STR.equalsIgnoreCase(string) || LOCALE_INDEPENDENT_STR.equalsIgnoreCase(string);
    }

    @Nullable
    public static String getValidLanguageCode(@Nullable String string) {
        if (StringHelper.hasText(string) && (RegExHelper.stringMatchesPattern("[a-zA-Z]{2,8}", string) || LocaleUtils.isSpecialLocaleCode(string))) {
            return string.toLowerCase(Locale.US);
        }
        return null;
    }

    @Nullable
    public static String getValidCountryCode(@Nullable String string) {
        if (StringHelper.hasText(string) && RegExHelper.stringMatchesPattern("[a-zA-Z]{2}|[0-9]{3}", string)) {
            return string.toUpperCase(CGlobal.LOCALE_FIXED_NUMBER_FORMAT);
        }
        return null;
    }

    @Nonnull
    public static EChange clearCache() {
        return s_aLocaleListCache.clearCache();
    }

    private static final class LocaleListCache
    extends AbstractNotifyingCache<Locale, List<Locale>> {
        public LocaleListCache() {
            super(LocaleListCache.class.getName());
        }

        @Override
        @Nullable
        @IsLocked(value=ELockType.WRITE)
        protected List<Locale> getValueToCache(@Nullable Locale locale) {
            if (locale == null) {
                return null;
            }
            ArrayList<Locale> arrayList = new ArrayList<Locale>(3);
            String string = locale.getLanguage();
            if (string.length() > 0) {
                arrayList.add(0, LocaleCache.getLocale(string));
                String string2 = locale.getCountry();
                if (string2.length() > 0) {
                    arrayList.add(0, LocaleCache.getLocale(string, string2));
                    String string3 = locale.getVariant();
                    if (string3.length() > 0) {
                        arrayList.add(0, LocaleCache.getLocale(string, string2, string3));
                    }
                }
            }
            return CollectionHelper.makeUnmodifiable(arrayList);
        }
    }
}

