/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasErrorLevel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class LogUtils {
    private static final LogUtils s_aInstance = new LogUtils();

    private LogUtils() {
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel) {
        return LogUtils.isEnabled(logger, iHasErrorLevel.getErrorLevel());
    }

    public static boolean isEnabled(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel) {
        return LogUtils.isEnabled(LoggerFactory.getLogger(clazz), iErrorLevel);
    }

    public static boolean isEnabled(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel) {
        if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            return logger.isErrorEnabled();
        }
        if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            return logger.isWarnEnabled();
        }
        if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            return logger.isInfoEnabled();
        }
        return logger.isDebugEnabled();
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogUtils.log(clazz, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(LoggerFactory.getLogger(clazz), iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string) {
        LogUtils.log(logger, iHasErrorLevel.getErrorLevel(), string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IHasErrorLevel iHasErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(logger, iHasErrorLevel.getErrorLevel(), string, throwable);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogUtils.log(clazz, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Class<?> clazz, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        LogUtils.log(LoggerFactory.getLogger(clazz), iErrorLevel, string, throwable);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string) {
        LogUtils.log(logger, iErrorLevel, string, null);
    }

    public static void log(@Nonnull Logger logger, @Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        ValueEnforcer.notNull(logger, "Logger");
        ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        ValueEnforcer.notNull(string, "Message");
        if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.ERROR)) {
            logger.error(string, throwable);
        } else if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.WARN)) {
            logger.warn(string, throwable);
        } else if (iErrorLevel.isMoreOrEqualSevereThan(EErrorLevel.INFO)) {
            logger.info(string, throwable);
        } else if (logger.isDebugEnabled()) {
            logger.debug(string, throwable);
        }
    }
}

