/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.convert.impl;

import com.helger.commons.annotations.IsSPIImplementation;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.locale.ComparatorLocale;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.commons.microdom.convert.IMicroTypeConverterRegistry;
import com.helger.commons.microdom.impl.MicroElement;
import com.helger.commons.text.ISimpleMultiLingualText;
import com.helger.commons.text.impl.MultiLingualText;
import com.helger.commons.text.impl.ReadonlyMultiLingualText;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class MultiLingualTextMicroTypeConverterRegistrar
implements IMicroTypeConverterRegistrarSPI {
    @Override
    public void registerMicroTypeConverter(@Nonnull IMicroTypeConverterRegistry iMicroTypeConverterRegistry) {
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(ReadonlyMultiLingualText.class, new AbstractMLTConverter(){

            @Override
            @Nonnull
            public ReadonlyMultiLingualText convertToNative(@Nonnull IMicroElement iMicroElement) {
                return new ReadonlyMultiLingualText(1.convertToMLT(iMicroElement));
            }
        });
        iMicroTypeConverterRegistry.registerMicroElementTypeConverter(MultiLingualText.class, new AbstractMLTConverter(){

            @Override
            @Nonnull
            public MultiLingualText convertToNative(@Nonnull IMicroElement iMicroElement) {
                return 2.convertToMLT(iMicroElement);
            }
        });
    }

    private static abstract class AbstractMLTConverter
    implements IMicroTypeConverter {
        private static final String ELEMENT_TEXT = "text";
        private static final String ATTR_LOCALE = "locale";

        private AbstractMLTConverter() {
        }

        @Override
        @Nonnull
        public final IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull @Nonempty String string2) {
            ISimpleMultiLingualText iSimpleMultiLingualText = (ISimpleMultiLingualText)object;
            MicroElement microElement = new MicroElement(string, string2);
            for (Locale locale : CollectionHelper.getSorted(iSimpleMultiLingualText.getAllLocales(), new ComparatorLocale())) {
                IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_TEXT);
                iMicroElement.setAttribute(ATTR_LOCALE, locale.toString());
                iMicroElement.appendText(iSimpleMultiLingualText.getText(locale));
            }
            return microElement;
        }

        @Nonnull
        protected static MultiLingualText convertToMLT(@Nonnull IMicroElement iMicroElement) {
            MultiLingualText multiLingualText = new MultiLingualText();
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_TEXT)) {
                Locale locale = LocaleCache.getLocale(iMicroElement2.getAttributeValue(ATTR_LOCALE));
                multiLingualText.setText(locale, iMicroElement2.getTextContent());
            }
            return multiLingualText;
        }
    }
}

