/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroDocumentType;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.impl.AbstractMicroNode;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocumentType
extends AbstractMicroNode
implements IMicroDocumentType {
    private final String m_sQualifiedName;
    private final String m_sPublicID;
    private final String m_sSystemID;

    public MicroDocumentType(@Nonnull IMicroDocumentType iMicroDocumentType) {
        this(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    public MicroDocumentType(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notEmpty(string, "QualifiedName");
        this.m_sQualifiedName = string;
        this.m_sPublicID = string2;
        this.m_sSystemID = string3;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT_TYPE;
    }

    @Override
    @Nonnull
    public String getNodeName() {
        return "#doctype";
    }

    @Override
    @Nonnull
    public String getQualifiedName() {
        return this.m_sQualifiedName;
    }

    @Override
    @Nullable
    public String getPublicID() {
        return this.m_sPublicID;
    }

    @Override
    @Nullable
    public String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    @Nonnull
    public IMicroDocumentType getClone() {
        return new MicroDocumentType(this);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!(iMicroNode instanceof MicroDocumentType)) {
            return false;
        }
        MicroDocumentType microDocumentType = (MicroDocumentType)iMicroNode;
        return this.m_sQualifiedName.equals(microDocumentType.m_sQualifiedName) && EqualsUtils.equals(this.m_sPublicID, microDocumentType.m_sPublicID) && EqualsUtils.equals(this.m_sSystemID, microDocumentType.m_sSystemID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("qualifiedName", this.m_sQualifiedName).append("publicID", this.m_sPublicID).append("systemID", this.m_sSystemID).toString();
    }
}

