/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareUtils;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.mutable.AbstractMutableNumeric;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableDouble
extends AbstractMutableNumeric<MutableDouble> {
    public static final double DEFAULT_VALUE = 0.0;
    private double m_dValue;

    public MutableDouble() {
        this(0.0);
    }

    public MutableDouble(@Nonnull Number number) {
        this(number.doubleValue());
    }

    public MutableDouble(double d) {
        this.m_dValue = d;
    }

    @Override
    public double doubleValue() {
        return this.m_dValue;
    }

    @Override
    public float floatValue() {
        return (float)this.m_dValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_dValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_dValue;
    }

    public double inc() {
        return this.inc(1.0);
    }

    public double inc(double d) {
        this.m_dValue += d;
        return this.m_dValue;
    }

    public double inc(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.doubleValue());
    }

    public double dec() {
        return this.inc(-1.0);
    }

    public double dec(double d) {
        return this.inc(-d);
    }

    public double dec(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.doubleValue());
    }

    public double divide(double d) {
        this.m_dValue /= d;
        return this.m_dValue;
    }

    public double divide(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Divisor");
        return this.divide(number.doubleValue());
    }

    public double multiply(double d) {
        this.m_dValue *= d;
        return this.m_dValue;
    }

    public double multiply(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Multiplicand");
        return this.multiply(number.doubleValue());
    }

    @Nonnull
    public EChange set(double d) {
        if (EqualsUtils.equals(d, this.m_dValue)) {
            return EChange.UNCHANGED;
        }
        this.m_dValue = d;
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange set(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.doubleValue());
    }

    @Override
    public boolean is0() {
        return EqualsUtils.equals(this.m_dValue, 0.0);
    }

    @Override
    public boolean isNot0() {
        return !this.is0();
    }

    @Override
    public boolean isSmaller0() {
        return CompareUtils.compare(this.m_dValue, 0.0) < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return CompareUtils.compare(this.m_dValue, 0.0) <= 0;
    }

    @Override
    public boolean isGreater0() {
        return CompareUtils.compare(this.m_dValue, 0.0) > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return CompareUtils.compare(this.m_dValue, 0.0) >= 0;
    }

    @Override
    public int compareTo(@Nonnull MutableDouble mutableDouble) {
        return CompareUtils.compare(this.m_dValue, mutableDouble.m_dValue);
    }

    @Override
    @Nonnull
    public MutableDouble getClone() {
        return new MutableDouble(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableDouble mutableDouble = (MutableDouble)object;
        return EqualsUtils.equals(this.m_dValue, mutableDouble.m_dValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_dValue).toString();
    }
}

