/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.regex;

import com.helger.commons.annotations.ELockType;
import com.helger.commons.annotations.IsLocked;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.cache.AbstractNotifyingCacheWithMaxSize;
import com.helger.commons.regex.RegExPattern;
import com.helger.commons.state.EChange;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;

public final class RegExPool
extends AbstractNotifyingCacheWithMaxSize<RegExPattern, Pattern> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static final RegExPool s_aInstance = new RegExPool();

    private RegExPool() {
        super(RegExPool.class.getName(), 1000);
    }

    @Override
    @Nullable
    @IsLocked(value=ELockType.WRITE)
    protected Pattern getValueToCache(@Nullable @RegEx RegExPattern regExPattern) {
        return regExPattern == null ? null : regExPattern.getAsPattern();
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string) {
        return (Pattern)s_aInstance.getFromCache(new RegExPattern(string));
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        return (Pattern)s_aInstance.getFromCache(new RegExPattern(string, n));
    }

    @Nonnull
    public static EChange clearPatternCache() {
        return s_aInstance.clearCache();
    }
}

