/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.lang.CGStringHelper;
import com.helger.commons.scopes.AbstractMapBasedScope;
import com.helger.commons.scopes.ScopeUtils;
import com.helger.commons.scopes.domain.IRequestScope;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScope
extends AbstractMapBasedScope
implements IRequestScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(RequestScope.class);
    private final String m_sSessionID;

    public RequestScope(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string);
        this.m_sSessionID = ValueEnforcer.notEmpty(string2, "SessionID");
        if (ScopeUtils.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created request scope '" + string + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getSessionID() {
        return this.getSessionID(true);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getSessionID(boolean bl) {
        return this.m_sSessionID;
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeUtils.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying request scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeUtils.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed request scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    @Deprecated
    @Nullable
    public List<String> getAttributeValues(@Nullable String string) {
        return this.getAttributeAsList(string);
    }

    @Override
    @Nullable
    public List<String> getAttributeAsList(@Nullable String string) {
        return this.getAttributeAsList(string, null);
    }

    @Override
    @Deprecated
    @Nullable
    public List<String> getAttributeValues(@Nullable String string, @Nullable List<String> list) {
        return this.getAttributeAsList(string, list);
    }

    @Nullable
    @OverrideOnDemand
    protected List<String> getAttributeAsListCustom(@Nullable String string, @Nonnull Object object, @Nullable List<String> list) {
        return list;
    }

    @Override
    @Nullable
    public List<String> getAttributeAsList(@Nullable String string, @Nullable List<String> list) {
        Object object = this.getAttributeObject(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String[]) {
            return CollectionHelper.newList((String[])object);
        }
        if (object instanceof String) {
            return CollectionHelper.newList((String)object);
        }
        return this.getAttributeAsListCustom(string, object, list);
    }

    @Override
    public boolean hasAttributeValue(@Nullable String string, @Nullable String string2) {
        return EqualsUtils.equals(this.getAttributeAsString(string), string2);
    }

    @Override
    public boolean hasAttributeValue(@Nullable String string, @Nullable String string2, boolean bl) {
        String string3 = this.getAttributeAsString(string);
        return string3 == null ? bl : EqualsUtils.equals(string3, string2);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("sessionID", this.m_sSessionID).toString();
    }
}

